/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.hawkular.bus.common.ConnectionContext;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.log.MsgLogger;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

public class ConnectionContextFactory
implements AutoCloseable {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ConnectionContextFactory.class);
    protected final ConnectionFactory connectionFactory;
    private Connection connection;

    public ConnectionContextFactory(String brokerURL) throws JMSException {
        this.connectionFactory = new ActiveMQConnectionFactory(brokerURL);
        this.log.debugf("%s has been created: %s", (Object)this.getClass().getSimpleName(), (Object)brokerURL);
    }

    public ConnectionContextFactory(String brokerURL, String username, String password) throws JMSException {
        this.connectionFactory = new ActiveMQConnectionFactory(username, password, brokerURL);
        this.log.debugf("%s has been created: [%s] with username [%s]", (Object)this.getClass().getSimpleName(), (Object)brokerURL, (Object)username);
    }

    public ConnectionContextFactory(ConnectionFactory connectionFactory) throws JMSException {
        this.connectionFactory = connectionFactory;
        this.log.debugf("%s has been created with an existing connection factory: %s", (Object)this.getClass().getSimpleName(), (Object)connectionFactory);
    }

    public ProducerConnectionContext createProducerConnectionContext(Endpoint endpoint) throws JMSException {
        ProducerConnectionContext context = new ProducerConnectionContext();
        this.createOrReuseConnection(context, true);
        this.createSession(context);
        this.createDestination(context, endpoint);
        this.createProducer(context);
        return context;
    }

    public ConsumerConnectionContext createConsumerConnectionContext(Endpoint endpoint) throws JMSException {
        return this.createConsumerConnectionContext(endpoint, null);
    }

    public ConsumerConnectionContext createConsumerConnectionContext(Endpoint endpoint, String messageSelector) throws JMSException {
        ConsumerConnectionContext context = new ConsumerConnectionContext();
        this.createOrReuseConnection(context, true);
        this.createSession(context);
        this.createDestination(context, endpoint);
        this.createConsumer(context, messageSelector);
        return context;
    }

    @Override
    public void close() throws JMSException {
        Connection conn = this.getConnection();
        if (conn != null) {
            conn.close();
        }
        this.log.debugf("%s has been closed", (Object)this);
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.msglog.errorCannotCloseConnectionMemoryMightLeak(e);
            }
        }
        this.connection = connection;
    }

    protected void createOrReuseConnection(ConnectionContext context, boolean start) throws JMSException {
        Connection conn = this.getConnection();
        if (conn != null) {
            context.setConnection(conn);
        } else {
            this.createConnection(context);
            conn = context.getConnection();
            this.setConnection(conn);
        }
        if (start) {
            try {
                conn.start();
            }
            catch (JMSException e) {
                this.msglog.errorFailedToStartConnection(e);
                this.setConnection(null);
                throw e;
            }
        }
    }

    protected void createConnection(ConnectionContext context) throws JMSException {
        if (context == null) {
            throw new IllegalStateException("The context is null");
        }
        ConnectionFactory factory = this.getConnectionFactory();
        Connection conn = factory.createConnection();
        context.setConnection(conn);
    }

    protected void createSession(ConnectionContext context) throws JMSException {
        if (context == null) {
            throw new IllegalStateException("The context is null");
        }
        Connection conn = context.getConnection();
        if (conn == null) {
            throw new IllegalStateException("The context had a null connection");
        }
        Session session = conn.createSession(false, 1);
        context.setSession(session);
    }

    protected void createDestination(ConnectionContext context, Endpoint endpoint) throws JMSException {
        if (endpoint == null) {
            throw new IllegalStateException("Endpoint is null");
        }
        if (context == null) {
            throw new IllegalStateException("The context is null");
        }
        Session session = context.getSession();
        if (session == null) {
            throw new IllegalStateException("The context had a null session");
        }
        Object dest = endpoint.getType() == Endpoint.Type.QUEUE ? (endpoint.isTemporary() ? session.createTemporaryQueue() : session.createQueue(endpoint.getName())) : (endpoint.isTemporary() ? session.createTemporaryTopic() : session.createTopic(endpoint.getName()));
        context.setDestination((Destination)dest);
    }

    protected void createProducer(ProducerConnectionContext context) throws JMSException {
        if (context == null) {
            throw new IllegalStateException("The context is null");
        }
        Session session = context.getSession();
        if (session == null) {
            throw new IllegalStateException("The context had a null session");
        }
        Destination dest = context.getDestination();
        if (dest == null) {
            throw new IllegalStateException("The context had a null destination");
        }
        MessageProducer producer = session.createProducer(dest);
        context.setMessageProducer(producer);
    }

    protected void createConsumer(ConsumerConnectionContext context, String messageSelector) throws JMSException {
        if (context == null) {
            throw new IllegalStateException("The context is null");
        }
        Session session = context.getSession();
        if (session == null) {
            throw new IllegalStateException("The context had a null session");
        }
        Destination dest = context.getDestination();
        if (dest == null) {
            throw new IllegalStateException("The context had a null destination");
        }
        MessageConsumer consumer = session.createConsumer(dest, messageSelector);
        context.setMessageConsumer(consumer);
    }
}

