/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import org.hawkular.bus.common.BasicMessage;

public class ObjectMessage
extends BasicMessage {
    @Expose
    private String message;
    private Class<?> objectClass;

    public ObjectMessage() {
    }

    public ObjectMessage(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        this.setObjectClass(object.getClass());
        Gson gson = new GsonBuilder().create();
        String msg = gson.toJson(object);
        this.setMessage(msg);
    }

    public ObjectMessage(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        this.setObjectClass(clazz);
    }

    @Override
    public String toJSON() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String msg) {
        this.message = msg;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
    }

    public Object getObject() {
        Class<?> clazz = this.getObjectClass();
        if (clazz == null) {
            throw new IllegalStateException("Do not know what the class is that represents the JSON data");
        }
        Gson gson = new GsonBuilder().create();
        return gson.fromJson(this.getMessage(), clazz);
    }
}

