/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.consumer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.log.MsgLogger;
import org.jboss.logging.Logger;

public abstract class AbstractBasicMessageListener<T extends BasicMessage>
implements MessageListener {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(this.getClass());
    private ConsumerConnectionContext consumerConnectionContext;
    private final Class<T> jsonDecoderRing;

    public AbstractBasicMessageListener() {
        this.jsonDecoderRing = this.determineBasicMessageClass();
    }

    protected AbstractBasicMessageListener(Class<T> jsonDecoderRing) {
        this.jsonDecoderRing = jsonDecoderRing;
    }

    public ConsumerConnectionContext getConsumerConnectionContext() {
        return this.consumerConnectionContext;
    }

    public void setConsumerConnectionContext(ConsumerConnectionContext consumerConnectionContext) {
        this.consumerConnectionContext = consumerConnectionContext;
    }

    protected T getBasicMessageFromMessage(Message message) {
        BasicMessage basicMessage;
        try {
            String receivedBody = ((TextMessage)message).getText();
            basicMessage = (BasicMessage)BasicMessage.fromJSON(receivedBody, this.getBasicMessageClass());
            basicMessage.setMessageId(new MessageId(message.getJMSMessageID()));
            if (message.getJMSCorrelationID() != null) {
                MessageId correlationId = new MessageId(message.getJMSCorrelationID());
                basicMessage.setCorrelationId(correlationId);
            }
            HashMap<String, String> rawHeaders = new HashMap<String, String>();
            Enumeration propNames = message.getPropertyNames();
            while (propNames.hasMoreElements()) {
                String propName = propNames.nextElement().toString();
                rawHeaders.put(propName, message.getStringProperty(propName));
            }
            if (!rawHeaders.isEmpty()) {
                basicMessage.setHeaders(rawHeaders);
            }
            this.getLog().tracef("Received basic message: %s", (Object)basicMessage);
        }
        catch (JMSException e) {
            this.msglog.errorNotValidTextMessage(e);
            basicMessage = null;
        }
        catch (Exception e) {
            this.msglog.errorNotValidJsonMessage(e);
            basicMessage = null;
        }
        return (T)basicMessage;
    }

    protected Class<T> getBasicMessageClass() {
        return this.jsonDecoderRing;
    }

    protected Class<T> determineBasicMessageClass() {
        Class clazz;
        Class<?> thisClazz = this.getClass();
        Type superClazz = thisClazz.getGenericSuperclass();
        while (superClazz instanceof Class) {
            superClazz = ((Class)superClazz).getGenericSuperclass();
        }
        ParameterizedType parameterizedType = (ParameterizedType)superClazz;
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
        if (actualTypeArgument instanceof Class) {
            clazz = (Class)actualTypeArgument;
        } else {
            TypeVariable typeVar = (TypeVariable)actualTypeArgument;
            clazz = (Class)typeVar.getBounds()[0];
        }
        return clazz;
    }

    protected Logger getLog() {
        return this.log;
    }
}

