/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.consumer;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.log.MsgLogger;
import org.hawkular.bus.common.producer.ProducerConnectionContext;

public abstract class RPCBasicMessageListener<T extends BasicMessage, U extends BasicMessage>
extends AbstractBasicMessageListener<T> {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private MessageProcessor messageSender;

    public RPCBasicMessageListener() {
        this.setMessageSender(new MessageProcessor());
    }

    public RPCBasicMessageListener(MessageProcessor messageSender) {
        this.setMessageSender(messageSender);
    }

    protected RPCBasicMessageListener(Class<T> jsonDecoderRing) {
        super(jsonDecoderRing);
        this.setMessageSender(new MessageProcessor());
    }

    protected RPCBasicMessageListener(Class<T> jsonDecoderRing, MessageProcessor messageSender) {
        super(jsonDecoderRing);
        this.setMessageSender(messageSender);
    }

    protected MessageProcessor getMessageSender() {
        return this.messageSender;
    }

    protected void setMessageSender(MessageProcessor messageSender) {
        this.messageSender = messageSender;
    }

    public void onMessage(Message message) {
        Object basicMessage = this.getBasicMessageFromMessage(message);
        if (basicMessage == null) {
            return;
        }
        U responseBasicMessage = this.onBasicMessage(basicMessage);
        try {
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null) {
                MessageProcessor sender = this.getMessageSender();
                if (sender == null) {
                    this.msglog.errorNoMessageSenderInListener();
                    return;
                }
                ConsumerConnectionContext consumerConnectionContext = this.getConsumerConnectionContext();
                if (consumerConnectionContext == null) {
                    this.msglog.errorNoConnectionContextInListener();
                    return;
                }
                ProducerConnectionContext producerContext = new ProducerConnectionContext();
                producerContext.copy(consumerConnectionContext);
                producerContext.setDestination(replyTo);
                Session session = producerContext.getSession();
                if (session == null) {
                    this.msglog.errorNoSessionInListener();
                    return;
                }
                producerContext.setMessageProducer(session.createProducer(replyTo));
                sender.send(producerContext, (BasicMessage)responseBasicMessage);
            } else {
                this.getLog().debug((Object)"Sender did not tell us where to reply - will not send any response back");
            }
        }
        catch (Exception e) {
            this.msglog.errorFailedToSendResponse(e);
            return;
        }
    }

    protected abstract U onBasicMessage(T var1);
}

