/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.bus.common.MessageId;

public abstract class BasicMessage {
    @JsonIgnore
    private MessageId _messageId;
    @JsonIgnore
    private MessageId _correlationId;
    @JsonIgnore
    private Map<String, String> _headers;

    public static <T extends BasicMessage> T fromJSON(String json, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)((BasicMessage)mapper.readValue(json, clazz));
        }
        catch (IOException e) {
            throw new IllegalStateException("JSON message cannot be converted to object.", e);
        }
    }

    public String toJSON() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Object cannot be parsed as JSON.", e);
        }
    }

    protected BasicMessage() {
    }

    public MessageId getMessageId() {
        return this._messageId;
    }

    public void setMessageId(MessageId messageId) {
        this._messageId = messageId;
    }

    public MessageId getCorrelationId() {
        return this._correlationId;
    }

    public void setCorrelationId(MessageId correlationId) {
        this._correlationId = correlationId;
    }

    public Map<String, String> getHeaders() {
        if (this._headers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._headers);
    }

    public void setHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            this._headers = null;
        } else if (this._headers == null) {
            this._headers = new HashMap<String, String>(headers);
        } else {
            this._headers.clear();
            this._headers.putAll(headers);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + ": [");
        str.append("message-id=");
        str.append(this.getMessageId());
        str.append(", correlation-id=");
        str.append(this.getCorrelationId());
        str.append(", headers=");
        str.append(this.getHeaders());
        str.append(", json-body=[");
        str.append(this.toJSON());
        str.append("]]");
        return str.toString();
    }
}

