/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.hawkular.bus.common.BasicMessage;

public class ObjectMessage
extends BasicMessage {
    @JsonInclude
    private String message;
    private Class<?> objectClass;

    public ObjectMessage() {
    }

    public ObjectMessage(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        this.setObjectClass(object.getClass());
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        try {
            String msg = mapper.writeValueAsString(object);
            this.setMessage(msg);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Object cannot be parsed as JSON.", e);
        }
    }

    public ObjectMessage(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        this.setObjectClass(clazz);
    }

    @Override
    public String toJSON() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String msg) {
        this.message = msg;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
    }

    public Object getObject() {
        Class<?> clazz = this.getObjectClass();
        if (clazz == null) {
            throw new IllegalStateException("Do not know what the class is that represents the JSON data");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readValue(this.getMessage(), clazz);
        }
        catch (IOException e) {
            throw new IllegalStateException("JSON message cannot be converted to object.", e);
        }
    }
}

