/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContext;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.consumer.RPCConnectionContext;
import org.hawkular.bus.common.producer.ProducerConnectionContext;

public class SimpleMessageProcessor
extends MessageProcessor {
    private final ConsumerConnectionContext consumerCtx;
    private final ProducerConnectionContext producerCtx;

    public SimpleMessageProcessor(ConsumerConnectionContext consumerCtx, ProducerConnectionContext producerCtx) {
        this.consumerCtx = consumerCtx;
        this.producerCtx = producerCtx;
    }

    public <T extends BasicMessage> void listen(AbstractBasicMessageListener<T> listener) throws JMSException {
        super.listen(this.consumerCtx, listener);
    }

    public MessageId send(BasicMessage basicMessage) throws JMSException {
        return super.send(this.producerCtx, basicMessage);
    }

    public MessageId send(BasicMessage basicMessage, Map<String, String> headers) throws JMSException {
        return super.send(this.producerCtx, basicMessage, headers);
    }

    public <T extends BasicMessage> RPCConnectionContext sendAndListen(BasicMessage basicMessage, BasicMessageListener<T> responseListener) throws JMSException {
        return super.sendAndListen(this.producerCtx, basicMessage, responseListener);
    }

    public <T extends BasicMessage> RPCConnectionContext sendAndListen(BasicMessage basicMessage, BasicMessageListener<T> responseListener, Map<String, String> headers) throws JMSException {
        return super.sendAndListen(this.producerCtx, basicMessage, responseListener, headers);
    }

    public <R extends BasicMessage> ListenableFuture<R> sendRPC(BasicMessage basicMessage, Class<R> expectedResponseMessageClass) throws JMSException {
        return super.sendRPC(this.producerCtx, basicMessage, expectedResponseMessageClass);
    }

    public <R extends BasicMessage> ListenableFuture<R> sendRPC(BasicMessage basicMessage, Class<R> expectedResponseMessageClass, Map<String, String> headers) throws JMSException {
        return super.sendRPC(this.producerCtx, basicMessage, expectedResponseMessageClass, headers);
    }

    @Override
    protected Message createMessage(ConnectionContext context, BasicMessage basicMessage) throws JMSException {
        return super.createMessage(context, basicMessage);
    }

    @Override
    protected Message createMessage(ConnectionContext context, BasicMessage basicMessage, Map<String, String> headers) throws JMSException {
        return super.createMessage(context, basicMessage, headers);
    }
}

