/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.consumer;

import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.hawkular.bus.common.AbstractMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.log.MsgLogger;
import org.jboss.logging.Logger;

public abstract class AbstractBasicMessageListener<T extends BasicMessage>
implements MessageListener {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(this.getClass());
    private ConsumerConnectionContext consumerConnectionContext;
    private final Class<T> jsonDecoderRing;
    private final ClassLoader basicMessageClassLoader;

    public AbstractBasicMessageListener() {
        this.jsonDecoderRing = this.determineBasicMessageClass();
        this.basicMessageClassLoader = null;
    }

    protected AbstractBasicMessageListener(Class<T> jsonDecoderRing) {
        this.jsonDecoderRing = jsonDecoderRing;
        this.basicMessageClassLoader = null;
    }

    protected AbstractBasicMessageListener(ClassLoader basicMessageClassLoader) {
        this.jsonDecoderRing = null;
        this.basicMessageClassLoader = basicMessageClassLoader;
    }

    public ConsumerConnectionContext getConsumerConnectionContext() {
        return this.consumerConnectionContext;
    }

    public void setConsumerConnectionContext(ConsumerConnectionContext consumerConnectionContext) {
        this.consumerConnectionContext = consumerConnectionContext;
    }

    protected BasicMessageWithExtraData<T> parseMessage(final Message message) {
        BasicMessageWithExtraData<T> retVal;
        try {
            Object receivedBody;
            Class<Object> basicMessageClass = null;
            String basicMessageClassName = message.getStringProperty("org.hawkular.bus.common.BasicMessage.className");
            basicMessageClass = this.basicMessageClassLoader != null && basicMessageClassName != null ? Class.forName(basicMessageClassName, true, this.basicMessageClassLoader) : this.getBasicMessageClass();
            if (message instanceof TextMessage) {
                receivedBody = ((TextMessage)message).getText();
                T basicMessage = AbstractMessage.fromJSON((String)receivedBody, basicMessageClass);
                retVal = new BasicMessageWithExtraData<T>(basicMessage, null);
            } else if (message instanceof ActiveMQBlobMessage) {
                receivedBody = ((ActiveMQBlobMessage)message).getInputStream();
                retVal = AbstractMessage.fromJSON((InputStream)receivedBody, basicMessageClass);
                BinaryData extraData = retVal.getBinaryData();
                if (extraData != null) {
                    extraData.setOnCloseAction(new Runnable(){

                        @Override
                        public void run() {
                            ActiveMQBlobMessage blob = (ActiveMQBlobMessage)message;
                            try {
                                AbstractBasicMessageListener.this.getLog().tracef("Deleting blob msg file [%s]", (Object)blob.getRemoteBlobUrl());
                                blob.deleteFile();
                            }
                            catch (Exception e) {
                                AbstractBasicMessageListener.this.getLog().warnf((Throwable)e, "Failed to delete blob msg file: [%s]", (Object)blob.getRemoteBlobUrl());
                            }
                        }
                    });
                }
            } else {
                throw new Exception("Unexpected implementation of " + Message.class.getName() + ": " + message.getClass() + " expected " + TextMessage.class.getName() + " or " + ActiveMQBlobMessage.class.getName() + ". Please report this bug.");
            }
            retVal.getBasicMessage().setMessageId(new MessageId(message.getJMSMessageID()));
            if (message.getJMSCorrelationID() != null) {
                MessageId correlationId = new MessageId(message.getJMSCorrelationID());
                retVal.getBasicMessage().setCorrelationId(correlationId);
            }
            HashMap<String, String> rawHeaders = new HashMap<String, String>();
            Enumeration propNames = message.getPropertyNames();
            while (propNames.hasMoreElements()) {
                String propName = propNames.nextElement().toString();
                rawHeaders.put(propName, message.getStringProperty(propName));
            }
            if (!rawHeaders.isEmpty()) {
                retVal.getBasicMessage().setHeaders(rawHeaders);
            }
            this.getLog().tracef("Received basic message: %s", retVal.getBasicMessage().getClass());
        }
        catch (JMSException e) {
            this.msglog.errorNotValidTextMessage(e);
            retVal = null;
        }
        catch (Exception e) {
            this.msglog.errorNotValidJsonMessage(e);
            retVal = null;
        }
        return retVal;
    }

    protected Class<T> getBasicMessageClass() {
        return this.jsonDecoderRing;
    }

    protected Class<T> determineBasicMessageClass() {
        Class clazz;
        Class<?> thisClazz = this.getClass();
        Type superClazz = thisClazz.getGenericSuperclass();
        while (superClazz instanceof Class) {
            superClazz = ((Class)superClazz).getGenericSuperclass();
        }
        ParameterizedType parameterizedType = (ParameterizedType)superClazz;
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
        if (actualTypeArgument instanceof Class) {
            clazz = (Class)actualTypeArgument;
        } else {
            TypeVariable typeVar = (TypeVariable)actualTypeArgument;
            clazz = (Class)typeVar.getBounds()[0];
        }
        return clazz;
    }

    protected Logger getLog() {
        return this.log;
    }
}

