/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.Message;
import org.apache.activemq.ScheduledMessage;
import org.apache.activemq.broker.scheduler.CronParser;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.PropertyExpression;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.TypeConversionSupport;
import org.fusesource.hawtbuf.UTF8Buffer;

public class ActiveMQMessage
extends org.apache.activemq.command.Message
implements Message,
ScheduledMessage {
    public static final byte DATA_STRUCTURE_TYPE = 23;
    public static final String DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY = "dlqDeliveryFailureCause";
    public static final String BROKER_PATH_PROPERTY = "JMSActiveMQBrokerPath";
    private static final Map<String, PropertySetter> JMS_PROPERTY_SETERS = new HashMap<String, PropertySetter>();
    protected transient Callback acknowledgeCallback;

    @Override
    public byte getDataStructureType() {
        return 23;
    }

    @Override
    public org.apache.activemq.command.Message copy() {
        ActiveMQMessage copy = new ActiveMQMessage();
        this.copy(copy);
        return copy;
    }

    protected void copy(ActiveMQMessage copy) {
        super.copy(copy);
        copy.acknowledgeCallback = this.acknowledgeCallback;
    }

    public int hashCode() {
        MessageId id = this.getMessageId();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ActiveMQMessage msg = (ActiveMQMessage)o;
        MessageId oMsg = msg.getMessageId();
        MessageId thisMsg = this.getMessageId();
        return thisMsg != null && oMsg != null && oMsg.equals(thisMsg);
    }

    public void acknowledge() throws JMSException {
        if (this.acknowledgeCallback != null) {
            try {
                this.acknowledgeCallback.execute();
            }
            catch (JMSException e) {
                throw e;
            }
            catch (Throwable e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.setContent(null);
        this.readOnlyBody = false;
    }

    public String getJMSMessageID() {
        MessageId messageId = this.getMessageId();
        if (messageId == null) {
            return null;
        }
        return messageId.toString();
    }

    public void setJMSMessageID(String value) throws JMSException {
        if (value != null) {
            try {
                MessageId id = new MessageId(value);
                this.setMessageId(id);
            }
            catch (NumberFormatException e) {
                MessageId id = new MessageId();
                id.setTextView(value);
                this.setMessageId(id);
            }
        } else {
            this.setMessageId(null);
        }
    }

    public void setJMSMessageID(ProducerId producerId, long producerSequenceId) throws JMSException {
        MessageId id = null;
        try {
            id = new MessageId(producerId, producerSequenceId);
            this.setMessageId(id);
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create("Invalid message id '" + id + "', reason: " + e.getMessage(), e);
        }
    }

    public long getJMSTimestamp() {
        return this.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) {
        this.setTimestamp(timestamp);
    }

    public String getJMSCorrelationID() {
        return this.getCorrelationId();
    }

    public void setJMSCorrelationID(String correlationId) {
        this.setCorrelationId(correlationId);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return ActiveMQMessage.encodeString(this.getCorrelationId());
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        this.setCorrelationId(ActiveMQMessage.decodeString(correlationId));
    }

    @Override
    public String getJMSXMimeType() {
        return "jms/message";
    }

    protected static String decodeString(byte[] data) throws JMSException {
        try {
            if (data == null) {
                return null;
            }
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Invalid UTF-8 encoding: " + e.getMessage());
        }
    }

    protected static byte[] encodeString(String data) throws JMSException {
        try {
            if (data == null) {
                return null;
            }
            return data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Invalid UTF-8 encoding: " + e.getMessage());
        }
    }

    public Destination getJMSReplyTo() {
        return this.getReplyTo();
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.setReplyTo(ActiveMQDestination.transform(destination));
    }

    public Destination getJMSDestination() {
        return this.getDestination();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.setDestination(ActiveMQDestination.transform(destination));
    }

    public int getJMSDeliveryMode() {
        return this.isPersistent() ? 2 : 1;
    }

    public void setJMSDeliveryMode(int mode) {
        this.setPersistent(mode == 2);
    }

    public boolean getJMSRedelivered() {
        return this.isRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.setRedelivered(redelivered);
    }

    public String getJMSType() {
        return this.getType();
    }

    public void setJMSType(String type) {
        this.setType(type);
    }

    public long getJMSExpiration() {
        return this.getExpiration();
    }

    public void setJMSExpiration(long expiration) {
        this.setExpiration(expiration);
    }

    public int getJMSPriority() {
        return this.getPriority();
    }

    public void setJMSPriority(int priority) {
        this.setPriority((byte)priority);
    }

    @Override
    public void clearProperties() {
        super.clearProperties();
        this.readOnlyProperties = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        try {
            return this.getProperties().containsKey(name) || this.getObjectProperty(name) != null;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Enumeration getPropertyNames() throws JMSException {
        try {
            Vector<String> result = new Vector<String>(this.getProperties().keySet());
            if (this.getRedeliveryCounter() != 0) {
                result.add("JMSXDeliveryCount");
            }
            if (this.getGroupID() != null) {
                result.add("JMSXGroupID");
            }
            if (this.getGroupID() != null) {
                result.add("JMSXGroupSeq");
            }
            if (this.getUserID() != null) {
                result.add("JMSXUserID");
            }
            return result.elements();
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Enumeration getAllPropertyNames() throws JMSException {
        try {
            Vector<String> result = new Vector<String>(this.getProperties().keySet());
            result.addAll(JMS_PROPERTY_SETERS.keySet());
            return result.elements();
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.setObjectProperty(name, value, true);
    }

    public void setObjectProperty(String name, Object value, boolean checkReadOnly) throws JMSException {
        if (checkReadOnly) {
            this.checkReadOnlyProperties();
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name cannot be empty or null");
        }
        if (value instanceof UTF8Buffer) {
            value = value.toString();
        }
        this.checkValidObject(value);
        value = this.convertScheduled(name, value);
        PropertySetter setter = JMS_PROPERTY_SETERS.get(name);
        if (setter != null && value != null) {
            setter.set(this, value);
        } else {
            try {
                this.setProperty(name, value);
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    public void setProperties(Map<String, ?> properties) throws JMSException {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.setObjectProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void checkValidObject(Object value) throws MessageFormatException {
        boolean valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
        boolean bl = valid = valid || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            ActiveMQConnection conn = this.getConnection();
            if (conn == null || conn.isNestedMapAndListEnabled()) {
                if (!(value instanceof Map) && !(value instanceof List)) {
                    throw new MessageFormatException("Only objectified primitive objects, String, Map and List types are allowed but was: " + value + " type: " + value.getClass());
                }
            } else {
                throw new MessageFormatException("Only objectified primitive objects and String types are allowed but was: " + value + " type: " + value.getClass());
            }
        }
    }

    protected void checkValidScheduled(String name, Object value) throws MessageFormatException {
        if (("AMQ_SCHEDULED_DELAY".equals(name) || "AMQ_SCHEDULED_PERIOD".equals(name) || "AMQ_SCHEDULED_REPEAT".equals(name)) && !(value instanceof Long) && !(value instanceof Integer)) {
            throw new MessageFormatException(name + " should be long or int value");
        }
        if ("AMQ_SCHEDULED_CRON".equals(name)) {
            CronParser.validate(value.toString());
        }
    }

    protected Object convertScheduled(String name, Object value) throws MessageFormatException {
        Object result = value;
        if ("AMQ_SCHEDULED_DELAY".equals(name)) {
            result = TypeConversionSupport.convert(value, Long.class);
        } else if ("AMQ_SCHEDULED_PERIOD".equals(name)) {
            result = TypeConversionSupport.convert(value, Long.class);
        } else if ("AMQ_SCHEDULED_REPEAT".equals(name)) {
            result = TypeConversionSupport.convert(value, Integer.class);
        }
        return result;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        PropertyExpression expression = new PropertyExpression(name);
        return expression.evaluate(this);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a boolean");
        }
        return rc;
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Byte rc = (Byte)TypeConversionSupport.convert(value, Byte.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a byte");
        }
        return rc;
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Short rc = (Short)TypeConversionSupport.convert(value, Short.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a short");
        }
        return rc;
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as an integer");
        }
        return rc;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a long");
        }
        return rc;
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Float rc = (Float)TypeConversionSupport.convert(value, Float.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a float");
        }
        return rc.floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Double rc = (Double)TypeConversionSupport.convert(value, Double.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a double");
        }
        return rc;
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = null;
        if (name.equals("JMSXUserID")) {
            value = this.getUserID();
            if (value == null) {
                value = this.getObjectProperty(name);
            }
        } else {
            value = this.getObjectProperty(name);
        }
        if (value == null) {
            return null;
        }
        String rc = (String)TypeConversionSupport.convert(value, String.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a String");
        }
        return rc;
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setBooleanProperty(name, value, true);
    }

    public void setBooleanProperty(String name, boolean value, boolean checkReadOnly) throws JMSException {
        this.setObjectProperty(name, value, checkReadOnly);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    private void checkReadOnlyProperties() throws MessageNotWriteableException {
        if (this.readOnlyProperties) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws MessageNotWriteableException {
        if (this.readOnlyBody) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
    }

    public Callback getAcknowledgeCallback() {
        return this.acknowledgeCallback;
    }

    public void setAcknowledgeCallback(Callback acknowledgeCallback) {
        this.acknowledgeCallback = acknowledgeCallback;
    }

    public void onSend() throws JMSException {
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
    }

    @Override
    public Response visit(CommandVisitor visitor) throws Exception {
        return visitor.processMessage(this);
    }

    @Override
    public void storeContent() {
    }

    @Override
    public void storeContentAndClear() {
        this.storeContent();
    }

    static {
        JMS_PROPERTY_SETERS.put("JMSXDeliveryCount", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXDeliveryCount cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setRedeliveryCounter(rc - 1);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSXGroupID", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXGroupID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupID(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSXGroupSeq", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXGroupSeq cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupSequence(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSCorrelationID", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSCorrelationID cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setJMSCorrelationID(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSDeliveryMode", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    Boolean bool = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                    if (bool == null) {
                        throw new MessageFormatException("Property JMSDeliveryMode cannot be set from a " + value.getClass().getName() + ".");
                    }
                    rc = bool != false ? 2 : 1;
                }
                ((ActiveMQMessage)message).setJMSDeliveryMode(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSExpiration", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSExpiration cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setJMSExpiration(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSPriority", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSPriority cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setJMSPriority(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSRedelivered", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSRedelivered cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setJMSRedelivered(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSReplyTo", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                ActiveMQDestination rc = (ActiveMQDestination)TypeConversionSupport.convert(value, ActiveMQDestination.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSReplyTo cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setReplyTo(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSTimestamp", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSTimestamp cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setJMSTimestamp(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSType", new PropertySetter(){

            @Override
            public void set(org.apache.activemq.command.Message message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSType cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setJMSType(rc);
            }
        });
    }

    static interface PropertySetter {
        public void set(org.apache.activemq.command.Message var1, Object var2) throws MessageFormatException;
    }
}

