/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.sample.mdb;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.SimpleBasicMessage;
import org.hawkular.bus.common.producer.ProducerConnectionContext;

public class VirtualTopicSendServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONN_FACTORY = "/HawkularBusConnectionFactory";
    private static final String TOPIC_NAME = "VirtualTopic.ExampleName";
    private static final Map<String, String> FNF_HEADER = VirtualTopicSendServlet.createMyFilterHeader((String)"fnf");

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userMessage = request.getParameter("jmsMessageFNF");
        if (userMessage == null) {
            throw new ServletException("Don't know what to send!");
        }
        this.fireAndForget(request, response, userMessage);
    }

    protected void fireAndForget(HttpServletRequest request, HttpServletResponse response, String userMessage) {
        try {
            InitialContext ctx = new InitialContext();
            TopicConnectionFactory qconFactory = (TopicConnectionFactory)ctx.lookup(CONN_FACTORY);
            ConnectionContextFactory ccf = new ConnectionContextFactory((ConnectionFactory)qconFactory);
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, TOPIC_NAME));
            SimpleBasicMessage msg = new SimpleBasicMessage(userMessage);
            MessageId mid = new MessageProcessor().send(pcc, (BasicMessage)msg, FNF_HEADER);
            PrintWriter out = response.getWriter();
            out.println("<h1>Fire and Forget</h1>");
            out.println("<p>BasicMessage Sent [" + msg + "]</p>");
            out.println("<p>(messageId=" + mid + ")</p>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> createMyFilterHeader(String value) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("MyFilter", value);
        return map;
    }
}

