/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.test;

import java.net.ServerSocket;
import org.hawkular.bus.broker.EmbeddedBroker;
import org.hawkular.bus.common.test.AbstractEmbeddedBrokerWrapper;

public class TCPEmbeddedBrokerWrapper
extends AbstractEmbeddedBrokerWrapper {
    private final int bindPort = this.findFreePort();

    public TCPEmbeddedBrokerWrapper() throws Exception {
        this.setBroker(new EmbeddedBroker(new String[]{"--config=" + this.getConfigurationFile(), "-Dtcp-testbroker.bind.port=" + this.bindPort}));
    }

    @Override
    public String getBrokerURL() {
        return "tcp://localhost:" + this.bindPort;
    }

    protected int findFreePort() throws Exception {
        try (ServerSocket ss = null;){
            ss = new ServerSocket(0);
            int n = ss.getLocalPort();
            return n;
        }
    }

    protected String getConfigurationFile() {
        return "simple-activemq.xml";
    }
}

