/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.test;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.hawkular.bus.common.ConnectionContext;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.producer.ProducerConnectionContext;

public class ProducerConnection
extends ConnectionContextFactory {
    private ProducerConnectionContext pcc;

    public ProducerConnection(String brokerURL, Endpoint endpoint) throws JMSException {
        super(brokerURL);
        this.prepareProducer(brokerURL, endpoint);
    }

    protected void prepareProducer(String brokerURL, Endpoint endpoint) throws JMSException {
        this.pcc = new ProducerConnectionContext();
        this.createConnection((ConnectionContext)this.pcc);
        this.cacheConnection(this.pcc.getConnection(), false);
        this.getConnection().start();
        this.createSession((ConnectionContext)this.pcc);
        this.createDestination((ConnectionContext)this.pcc, endpoint);
        this.pcc.setMessageProducer(this.pcc.getSession().createProducer(this.pcc.getDestination()));
    }

    public ProducerConnectionContext getConsumerConnectionContext() {
        return this.pcc;
    }

    public void sendMessage(String msg) throws JMSException {
        TextMessage producerMessage = this.pcc.getSession().createTextMessage(msg);
        this.pcc.getMessageProducer().send((Message)producerMessage);
    }
}

