/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.bus.common.AbstractMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;

public class SimpleTestListener<T extends AbstractMessage>
extends BasicMessageListener<T> {
    private CountDownLatch latch = new CountDownLatch(1);
    public T message;

    public SimpleTestListener(Class<T> clazz) {
        super(clazz);
    }

    public boolean waitForMessage(long secs) throws InterruptedException {
        return this.latch.await(secs, TimeUnit.SECONDS);
    }

    public T getReceivedMessage() {
        T result = null;
        if (this.message != null) {
            result = this.message;
            this.latch = new CountDownLatch(1);
            this.message = null;
        }
        return result;
    }

    protected void onBasicMessage(BasicMessageWithExtraData<T> message) {
        this.message = (AbstractMessage)message.getBasicMessage();
        this.latch.countDown();
    }
}

