/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.test;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import javax.jms.JMSException;
import org.hawkular.bus.common.AbstractMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;

public class StoreAndLatchBasicMessageListener<T extends AbstractMessage>
extends BasicMessageListener<T> {
    private final CountDownLatch latch;
    private final ArrayList<T> messages;
    private final ArrayList<String> errors;

    public StoreAndLatchBasicMessageListener(CountDownLatch latch, ArrayList<T> messages, ArrayList<String> errors, Class<T> basicMessageClass) {
        super(basicMessageClass);
        this.latch = latch;
        this.messages = messages;
        this.errors = errors;
    }

    public void onBasicMessage(BasicMessageWithExtraData<T> msgWithData) {
        try {
            this.storeMessage((AbstractMessage)msgWithData.getBasicMessage());
        }
        catch (Exception ex) {
            this.storeError(ex);
        }
        finally {
            this.countDownLatch();
        }
    }

    protected CountDownLatch getLatch() {
        return this.latch;
    }

    protected ArrayList<T> getMessages() {
        return this.messages;
    }

    protected ArrayList<String> getErrors() {
        return this.errors;
    }

    protected void countDownLatch() {
        CountDownLatch l = this.getLatch();
        if (l != null) {
            l.countDown();
        }
    }

    protected void storeError(Exception exception) {
        ArrayList<String> e = this.getErrors();
        if (e != null) {
            e.add(exception.toString());
        } else {
            exception.printStackTrace();
        }
    }

    protected void storeMessage(T message) throws JMSException {
        ArrayList<T> m = this.getMessages();
        if (m != null) {
            m.add(message);
        }
    }
}

