/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.api;

import org.hawkular.bus.common.BasicMessage;

public class ApiDeserializer {
    private static final String API_PKG = ApiDeserializer.class.getPackage().getName();

    public static String toHawkularFormat(BasicMessage msg) {
        return String.format("%s=%s", msg.getClass().getSimpleName(), msg.toJSON());
    }

    private static String[] fromHawkularFormat(String msg) {
        String[] nameAndJsonArray = msg.split("=", 2);
        if (nameAndJsonArray.length != 2) {
            throw new IllegalArgumentException("Cannot deserialize: [" + msg + "]");
        }
        return nameAndJsonArray;
    }

    public <T extends BasicMessage> T deserialize(String nameAndJson) {
        String[] nameAndJsonArray = ApiDeserializer.fromHawkularFormat(nameAndJson);
        String name = nameAndJsonArray[0];
        String json = nameAndJsonArray[1];
        if (name.indexOf(".") == -1) {
            name = String.format("%s.%s", API_PKG, name);
        }
        try {
            Class<?> pojo = Class.forName(name);
            return (T)BasicMessage.fromJSON((String)json, pojo);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize: [" + nameAndJson + "]", e);
        }
    }
}

