/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.api;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.hawkular.feedcomm.api.GenericErrorResponse;

public class GenericErrorResponseBuilder {
    private final GenericErrorResponse response = new GenericErrorResponse();

    public static GenericErrorResponse buildWithThrowable(Throwable t) {
        return new GenericErrorResponseBuilder().setThrowable(t).build();
    }

    public GenericErrorResponse build() {
        return this.response;
    }

    public GenericErrorResponseBuilder setErrorMessage(String errorMessage) {
        this.response.setErrorMessage(errorMessage);
        return this;
    }

    public GenericErrorResponseBuilder setStackTrace(String stackTrace) {
        this.response.setStackTrace(stackTrace);
        return this;
    }

    public GenericErrorResponseBuilder setThrowable(Throwable t) {
        this.setErrorMessage(t.getMessage());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(baos);){
            t.printStackTrace(pw);
        }
        this.setStackTrace(baos.toString());
        return this;
    }
}

