
package org.hawkular.feedcomm.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.hawkular.bus.common.BasicMessage;


/**
 * Deploys an application to a resource. The actual deployment file content must be appended to this JSON message.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "resourcePath",
    "destinationFileName"
})
public class DeployApplicationRequest
    extends BasicMessage
{

    /**
     * The inventory path to the resource that is to deploy the application
     * 
     */
    @JsonProperty("resourcePath")
    private String resourcePath;
    @JsonProperty("destinationFileName")
    private String destinationFileName;

    /**
     * The inventory path to the resource that is to deploy the application
     * 
     * @return
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public String getResourcePath() {
        return resourcePath;
    }

    /**
     * The inventory path to the resource that is to deploy the application
     * 
     * @param resourcePath
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * 
     * @return
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public String getDestinationFileName() {
        return destinationFileName;
    }

    /**
     * 
     * @param destinationFileName
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

}
