/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.command.ui;

import java.util.Collections;
import java.util.Map;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.feedcomm.api.ExecuteOperationRequest;
import org.hawkular.feedcomm.api.GenericSuccessResponse;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;

public class ExecuteOperationCommand
implements Command<ExecuteOperationRequest, GenericSuccessResponse> {
    public static final Class<ExecuteOperationRequest> REQUEST_CLASS = ExecuteOperationRequest.class;

    public GenericSuccessResponse execute(ExecuteOperationRequest request, CommandContext context) throws Exception {
        GenericSuccessResponse response;
        String feedId = request.getResourceId().split("~", 3)[0];
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = new Endpoint(Endpoint.Type.QUEUE, "FeedExecuteOperation");
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            Map<String, String> feedIdHeader = Collections.singletonMap("feedId", feedId);
            MessageId mid = new MessageProcessor().send(pcc, (BasicMessage)request, feedIdHeader);
            response = new GenericSuccessResponse();
            response.setMessage("The execution request has been forwarded to feed [" + feedId + "] (id=" + mid + ")");
        }
        return response;
    }
}

