/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.persistence.PostRemove;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.mdb.ExecuteOperationListener;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FeedListenerGenerator {
    @EJB
    private ConnectedFeeds connectedFeeds;
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;
    private Map<String, ConnectionContextFactory> connContextFactories;
    private Map<String, List<ConsumerConnectionContext>> consumerContexts;

    @PostConstruct
    public void initialize() throws Exception {
        if (this.connectionFactory == null) {
            MsgLogger.LOG.warnf("Injection of ConnectionFactory is not working - looking it up explicitly", new Object[0]);
            InitialContext ctx = new InitialContext();
            this.connectionFactory = (ConnectionFactory)ctx.lookup("java:/HawkularBusConnectionFactory");
        } else {
            MsgLogger.LOG.warnf("Injection of ConnectionFactory works - you can remove the hack", new Object[0]);
        }
        this.connContextFactories = new HashMap();
        this.consumerContexts = new HashMap();
    }

    @PostRemove
    public void shutdown() throws Exception {
        if (this.connContextFactories != null) {
            for (String feedId : this.connContextFactories.keySet()) {
                this.removeListeners(feedId);
            }
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void addListeners(String feedId) throws Exception {
        this.removeListeners(feedId);
        ConnectionContextFactory ccf = new ConnectionContextFactory(true, this.connectionFactory);
        this.connContextFactories.put(feedId, ccf);
        ArrayList<ConsumerConnectionContext> contextList = new ArrayList<ConsumerConnectionContext>();
        this.consumerContexts.put(feedId, contextList);
        MsgLogger.LOG.infof("Adding listeners for feed [%s]", (Object)feedId);
        MessageProcessor messageProcessor = new MessageProcessor();
        String messageSelector = String.format("%s = '%s'", "feedId", feedId);
        Endpoint endpoint = new Endpoint(Endpoint.Type.QUEUE, "FeedExecuteOperation");
        ConsumerConnectionContext ccc = ccf.createConsumerConnectionContext(endpoint, messageSelector);
        messageProcessor.listen(ccc, (AbstractBasicMessageListener)new ExecuteOperationListener(this.connectedFeeds));
        contextList.add(ccc);
    }

    public void removeListeners(String feedId) {
        List contextList = (List)this.consumerContexts.remove(feedId);
        ConnectionContextFactory factory = (ConnectionContextFactory)this.connContextFactories.remove(feedId);
        if (contextList != null) {
            for (ConsumerConnectionContext context : contextList) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    MsgLogger.LOG.errorf((Throwable)e, "Failed to close consumer context; will keep trying to close the rest", new Object[0]);
                }
            }
        }
        if (factory != null) {
            try {
                MsgLogger.LOG.infof("Removing listeners for feed [%s]", (Object)feedId);
                factory.close();
            }
            catch (Exception e) {
                MsgLogger.LOG.errorf((Throwable)e, "Failed to removing listeners for feed [%s]", (Object)feedId);
            }
        }
    }
}

