/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.feedcomm.api.ApiDeserializer;
import org.hawkular.feedcomm.api.GenericErrorResponse;
import org.hawkular.feedcomm.api.GenericErrorResponseBuilder;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;
import org.hawkular.feedcomm.ws.command.EchoCommand;
import org.hawkular.feedcomm.ws.command.GenericErrorResponseCommand;
import org.hawkular.feedcomm.ws.command.ui.ExecuteOperationCommand;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;

@ServerEndpoint(value="/ui/ws")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class UIClientCommWebSocket {
    private static final Map<String, Class<? extends Command<?, ?>>> VALID_COMMANDS = new HashMap();
    @Inject
    private ConnectedFeeds connectedFeeds;
    @Inject
    private ConnectedUIClients connectedUIClients;
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;

    @PostConstruct
    public void lookupConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            MsgLogger.LOG.warnf("Injection of ConnectionFactory is not working - looking it up explicitly", new Object[0]);
            InitialContext ctx = new InitialContext();
            this.connectionFactory = (ConnectionFactory)ctx.lookup("java:/HawkularBusConnectionFactory");
        }
    }

    @OnOpen
    public void uiClientSessionOpen(Session session) {
        MsgLogger.LOG.infof("UI client session [%s] opened", (Object)session.getId());
        this.connectedUIClients.addSession(session);
    }

    @OnMessage
    public String uiClientMessage(String nameAndJsonStr, Session session) {
        GenericErrorResponse response;
        MsgLogger.LOG.infof("Received message from UI client [%s]", (Object)session.getId());
        String requestClassName = "?";
        try {
            BasicMessage request = new ApiDeserializer().deserialize(nameAndJsonStr);
            requestClassName = request.getClass().getName();
            Class commandClass = (Class)VALID_COMMANDS.get(requestClassName);
            if (commandClass == null) {
                MsgLogger.LOG.errorInvalidCommandRequestUIClient(session.getId(), requestClassName);
                String errorMessage = "Invalid command request: " + requestClassName;
                response = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
            } else {
                CommandContext context = new CommandContext(this.connectedFeeds, this.connectedUIClients, this.connectionFactory);
                Command command = (Command)commandClass.newInstance();
                response = command.execute(request, context);
            }
        }
        catch (Throwable t) {
            MsgLogger.LOG.errorCommandExecutionFailureUIClient(requestClassName, session.getId(), t);
            String errorMessage = "Command failed[" + requestClassName + "]";
            response = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
        }
        String responseText = response == null ? null : ApiDeserializer.toHawkularFormat((BasicMessage)response);
        return responseText;
    }

    @OnClose
    public void uiClientSessionClose(Session session, CloseReason reason) {
        MsgLogger.LOG.infof("UI client session [%s] closed. Reason=[%s]", (Object)session.getId(), (Object)reason);
        this.connectedUIClients.removeSession(session);
    }

    static {
        VALID_COMMANDS.put(EchoCommand.REQUEST_CLASS.getName(), EchoCommand.class);
        VALID_COMMANDS.put(GenericErrorResponseCommand.REQUEST_CLASS.getName(), GenericErrorResponseCommand.class);
        VALID_COMMANDS.put(ExecuteOperationCommand.REQUEST_CLASS.getName(), ExecuteOperationCommand.class);
    }
}

