/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.mdb;

import java.util.Collection;
import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.feedcomm.api.ExecuteOperationResponse;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.WebSocketHelper;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;

public class ExecuteOperationResponseListener
extends BasicMessageListener<ExecuteOperationResponse> {
    private ConnectedUIClients connectedUIClients;

    public ExecuteOperationResponseListener(ConnectedUIClients connectedUIClients) {
        this.connectedUIClients = connectedUIClients;
    }

    protected void onBasicMessage(BasicMessageWithExtraData<ExecuteOperationResponse> responseWithData) {
        try {
            ExecuteOperationResponse response = (ExecuteOperationResponse)responseWithData.getBasicMessage();
            String uiClientId = (String)response.getHeaders().get("uiClientId");
            if (uiClientId == null) {
                MsgLogger.LOG.warnf("HACK: Telling ALL UI that operation [%s] on resource ID [%s] resulted in [%s]", (Object)response.getOperationName(), (Object)response.getResourceId(), (Object)response.getStatus());
                new WebSocketHelper().sendBasicMessageAsync((Collection)this.connectedUIClients.getAllSessions(), (BasicMessage)response);
                return;
            }
            Session session = this.connectedUIClients.getSessionBySessionId(uiClientId);
            if (session == null) {
                return;
            }
            MsgLogger.LOG.infof("Telling UI client [%s] that operation [%s] on resource ID [%s] resulted in [%s]", new Object[]{uiClientId, response.getOperationName(), response.getResourceId(), response.getStatus()});
            new WebSocketHelper().sendBasicMessageAsync(session, (BasicMessage)response);
            return;
        }
        catch (Exception e) {
            MsgLogger.LOG.errorCannotProcessExecuteOperationResponseMessage((Throwable)e);
            return;
        }
    }
}

