/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.websocket.Session;
import org.hawkular.feedcomm.ws.MsgLogger;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ConnectedUIClients {
    private Map<String, Session> sessions;

    @PostConstruct
    public void initialize() {
        MsgLogger.LOG.debugf("ConnectedUIClients has initialized", new Object[0]);
        this.sessions = new HashMap();
    }

    @Lock(value=LockType.READ)
    public int getTotalSessions() {
        return this.sessions.size();
    }

    @Lock(value=LockType.READ)
    public Set<Session> getAllSessions() {
        return new HashSet<Session>(this.sessions.values());
    }

    @Lock(value=LockType.READ)
    public Set<String> getAllSessionIds() {
        return new HashSet<String>(this.sessions.keySet());
    }

    @Lock(value=LockType.READ)
    public Session getSessionBySessionId(String sessionId) {
        return (Session)this.sessions.get(sessionId);
    }

    @Lock(value=LockType.WRITE)
    public void addSession(Session newSession) {
        this.sessions.put(newSession.getId(), newSession);
        MsgLogger.LOG.infof("A UI client session has been added [%s]. There are now [%d] connected UI clients", (Object)newSession.getId(), (Object)this.sessions.size());
    }

    @Lock(value=LockType.WRITE)
    public void removeSession(Session doomedSession) {
        Session removed = (Session)this.sessions.remove(doomedSession.getId());
        if (removed != null) {
            MsgLogger.LOG.infof("A UI client session has been removed [%s]. There are now [%d] connected UI clients", (Object)removed.getId(), (Object)this.sessions.size());
        }
    }
}

