/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.command;

import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.feedcomm.api.EchoRequest;
import org.hawkular.feedcomm.api.EchoResponse;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;

public class EchoCommand
implements Command<EchoRequest, EchoResponse> {
    public static final Class<EchoRequest> REQUEST_CLASS = EchoRequest.class;

    public EchoResponse execute(EchoRequest echoRequest, BinaryData binaryData, CommandContext context) {
        String echo = String.format("ECHO [%s]", echoRequest.getEchoMessage());
        StringBuilder extra = new StringBuilder();
        if (binaryData != null) {
            try (Scanner scanner = new Scanner((InputStream)binaryData, "UTF-8");){
                scanner.useDelimiter("\\A");
                extra.append(scanner.next());
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
        EchoResponse echoResponse = new EchoResponse();
        echoResponse.setReply(echo + extra.toString());
        return echoResponse;
    }
}

