/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.command.feed;

import java.util.Collections;
import java.util.Map;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.feedcomm.api.ExecuteOperationResponse;
import org.hawkular.feedcomm.ws.Constants;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;

public class ExecuteOperationResponseCommand
implements Command<ExecuteOperationResponse, BasicMessage> {
    public static final Class<ExecuteOperationResponse> REQUEST_CLASS = ExecuteOperationResponse.class;

    public BasicMessage execute(ExecuteOperationResponse response, BinaryData binaryData, CommandContext context) throws Exception {
        String resPath = response.getResourcePath();
        String opName = response.getOperationName();
        String status = response.getStatus();
        String msg = response.getMessage();
        MsgLogger.LOG.infof("Operation execution completed. Resource=[%s], Operation=[%s], Status=[%s], Message=[%s]", new Object[]{resPath, opName, status, msg});
        Object uiClientId = null;
        if (uiClientId == null) {
            try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
                Endpoint endpoint = Constants.DEST_UICLIENT_EXECUTE_OP_RESPONSE;
                ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
                new MessageProcessor().send(pcc, (BasicMessage)response);
            }
        }
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = Constants.DEST_UICLIENT_EXECUTE_OP_RESPONSE;
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            Map<String, Object> uiClientIdHeader = Collections.singletonMap("uiClientId", uiClientId);
            new MessageProcessor().send(pcc, (BasicMessage)response, uiClientIdHeader);
        }
        return null;
    }
}

