/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.command.ui;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.feedcomm.api.DeployApplicationRequest;
import org.hawkular.feedcomm.api.GenericSuccessResponse;
import org.hawkular.feedcomm.ws.Constants;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;
import org.hawkular.inventory.api.model.CanonicalPath;

public class DeployApplicationCommand
implements Command<DeployApplicationRequest, GenericSuccessResponse> {
    public static final Class<DeployApplicationRequest> REQUEST_CLASS = DeployApplicationRequest.class;

    public GenericSuccessResponse execute(DeployApplicationRequest request, BinaryData binaryData, CommandContext context) throws Exception {
        CanonicalPath resourcePath = CanonicalPath.fromString((String)request.getResourcePath());
        String feedId = resourcePath.ids().getFeedId();
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = Constants.DEST_FEED_DEPLOY_APPLICATION;
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            Map<String, String> feedIdHeader = Collections.singletonMap("feedId", feedId);
            MessageId mid = new MessageProcessor().sendWithBinaryData(pcc, (BasicMessage)request, (InputStream)binaryData, feedIdHeader);
            MsgLogger.LOG.debugf("File upload request placed on bus. mid=[%s], request=[%s]", (Object)mid, (Object)request);
            GenericSuccessResponse response = new GenericSuccessResponse();
            response.setMessage("The execution request has been forwarded to feed [" + feedId + "] (id=" + mid + ")");
            GenericSuccessResponse genericSuccessResponse = response;
            return genericSuccessResponse;
        }
    }
}

