/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.hawkular.feedcomm.ws.MsgLogger;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ConnectedFeeds {
    private Map<String, Session> sessions;

    @PostConstruct
    public void initialize() {
        MsgLogger.LOG.debugf("ConnectedFeeds has initialized", new Object[0]);
        this.sessions = new HashMap();
    }

    @Lock(value=LockType.READ)
    public int getTotalSessions() {
        return this.sessions.size();
    }

    @Lock(value=LockType.READ)
    public Session getSession(String feedId) {
        return (Session)this.sessions.get(feedId);
    }

    @Lock(value=LockType.READ)
    public Set<Session> getAllSessions() {
        return new HashSet<Session>(this.sessions.values());
    }

    @Lock(value=LockType.READ)
    public Set<String> getAllFeeds() {
        return new HashSet<String>(this.sessions.keySet());
    }

    @Lock(value=LockType.WRITE)
    public boolean addSession(String feedId, Session newSession) {
        Session oldSession = this.sessions.putIfAbsent(feedId, newSession);
        if (oldSession == null) {
            MsgLogger.LOG.infof("A feed session has been added [%s]. There are now [%d] connected feeds", (Object)feedId, (Object)this.sessions.size());
        } else {
            try {
                MsgLogger.LOG.errorClosingExtraFeedSession(feedId);
                newSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Cannot have multiple sessions open, the new one will be closed"));
            }
            catch (Exception e) {
                MsgLogger.LOG.errorCannotCloseExtraFeedSession(feedId, (Throwable)e);
            }
        }
        return oldSession == null;
    }

    @Lock(value=LockType.WRITE)
    public Session removeSession(String feedId, Session doomedSession) {
        Session removed = null;
        if (doomedSession == null) {
            removed = (Session)this.sessions.remove(feedId);
        } else {
            Session existingSession = (Session)this.sessions.get(feedId);
            if (existingSession != null && existingSession.getId().equals(doomedSession.getId())) {
                removed = (Session)this.sessions.remove(feedId);
            }
        }
        if (removed != null) {
            MsgLogger.LOG.infof("Session [%s] for feed [%s] has been removed. There are now [%d] connected feeds", (Object)removed.getId(), (Object)feedId, (Object)this.sessions.size());
        }
        return removed;
    }
}

