/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.command.feed;

import java.util.Collections;
import java.util.Map;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.feedcomm.api.DeployApplicationResponse;
import org.hawkular.feedcomm.ws.Constants;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;

public class DeployApplicationResponseCommand
implements Command<DeployApplicationResponse, BasicMessage> {
    public static final Class<DeployApplicationResponse> REQUEST_CLASS = DeployApplicationResponse.class;

    public BasicMessage execute(DeployApplicationResponse response, BinaryData binaryData, CommandContext context) throws Exception {
        String resPath = response.getResourcePath();
        String fileName = response.getDestinationFileName();
        String status = response.getStatus();
        String msg = response.getMessage();
        MsgLogger.LOG.infof("Deploy app request completed. Resource=[%s], FileName=[%s], Status=[%s], Message=[%s]", new Object[]{resPath, fileName, status, msg});
        Object uiClientId = null;
        if (uiClientId == null) {
            try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
                Endpoint endpoint = Constants.DEST_UICLIENT_DEPLOY_APPLICATION_RESPONSE;
                ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
                new MessageProcessor().send(pcc, (BasicMessage)response);
            }
        }
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = Constants.DEST_UICLIENT_DEPLOY_APPLICATION_RESPONSE;
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            Map<String, Object> uiClientIdHeader = Collections.singletonMap("uiClientId", uiClientId);
            new MessageProcessor().send(pcc, (BasicMessage)response, uiClientIdHeader);
        }
        return null;
    }
}

