/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.mdb;

import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.feedcomm.api.ExecuteOperationRequest;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.WebSocketHelper;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;

public class ExecuteOperationListener
extends BasicMessageListener<ExecuteOperationRequest> {
    private ConnectedFeeds connectedFeeds;

    public ExecuteOperationListener(ConnectedFeeds connectedFeeds) {
        this.connectedFeeds = connectedFeeds;
    }

    protected void onBasicMessage(BasicMessageWithExtraData<ExecuteOperationRequest> request) {
        try {
            ExecuteOperationRequest basicMessage = (ExecuteOperationRequest)request.getBasicMessage();
            String feedId = (String)basicMessage.getHeaders().get("feedId");
            if (feedId == null) {
                throw new IllegalArgumentException("Missing header: feedId");
            }
            Session session = this.connectedFeeds.getSession(feedId);
            if (session == null) {
                return;
            }
            MsgLogger.LOG.infof("Asking feed [%s] to execute operation [%s] on resource [%s]", (Object)feedId, (Object)basicMessage.getOperationName(), (Object)basicMessage.getResourcePath());
            new WebSocketHelper().sendBasicMessageAsync(session, (BasicMessage)basicMessage);
            return;
        }
        catch (Exception e) {
            MsgLogger.LOG.errorCannotProcessExecuteOperationMessage((Throwable)e);
            return;
        }
    }
}

