/*
 * Copyright 2015-2017 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.client.core.jaxrs;

public enum ResponseCodes {

    GET_SUCCESS_200(200),
    CREATE_SUCCESS_200(200),
    CREATE_SUCCESS_201(201),
    UPDATE_SUCCESS_204(204),
    UPDATE_SUCCESS_200(200),
    DELETE_SUCCESS_200(200),
    DELETE_SUCCESS_204(204),
    NO_CONTENT_204(204);

    private int code;

    ResponseCodes(int code) {
        this.code = code;
    }

    public int value() {
        return this.code;
    }

    @Override
    public String toString() {
        return String.valueOf(this.code);
    }
}
