/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.alert.jaxrs.handlers;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.model.data.Data;

@Path(value="/hawkular/alerts")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface AlertHandler {
    @GET
    @Path(value="/")
    public Response findAlerts(@QueryParam(value="startTime") Long var1, @QueryParam(value="endTime") Long var2, @QueryParam(value="alertIds") String var3, @QueryParam(value="triggerIds") String var4, @QueryParam(value="statuses") String var5, @QueryParam(value="severities") String var6, @QueryParam(value="tags") String var7, @QueryParam(value="thin") Boolean var8);

    @PUT
    @Path(value="/ack")
    public Response ackAlerts(@QueryParam(value="alertIds") String var1, @QueryParam(value="ackBy") String var2, @QueryParam(value="ackNotes") String var3);

    @PUT
    @Path(value="/ack/{alertId}")
    public Response ackAlert(@PathParam(value="alertId") String var1, @QueryParam(value="ackBy") String var2, @QueryParam(value="ackNotes") String var3);

    @GET
    @Path(value="/alert/{alertId}")
    public Response getAlert(@PathParam(value="alertId") String var1, @QueryParam(value="thin") Boolean var2);

    @POST
    @Path(value="/data")
    public Response sendData(List<Data> var1);

    @PUT
    @Path(value="/delete")
    public Response deleteAlerts(@QueryParam(value="startTime") Long var1, @QueryParam(value="endTime") Long var2, @QueryParam(value="alertIds") String var3, @QueryParam(value="triggerIds") String var4, @QueryParam(value="statuses") String var5, @QueryParam(value="severities") String var6, @QueryParam(value="tags") String var7);

    @PUT
    @Path(value="/note/{alertId}")
    public Response addNoteToAlert(@PathParam(value="alertId") String var1, @QueryParam(value="user") String var2, @QueryParam(value="text") String var3);

    @PUT
    @Path(value="/resolve")
    public Response resolveAlerts(@QueryParam(value="alertIds") String var1, @QueryParam(value="resolvedBy") String var2, @QueryParam(value="resolvedNotes") String var3);

    @PUT
    @Path(value="/resolve/{alertId}")
    public Response resolveAlert(@PathParam(value="alertId") String var1, @QueryParam(value="resolvedBy") String var2, @QueryParam(value="resolvedNotes") String var3);

    @DELETE
    @Path(value="/tags")
    public Response deleteTags(@QueryParam(value="alertIds") String var1, @QueryParam(value="tagNames") String var2);

    @PUT
    @Path(value="/tags")
    public Response addTag(@QueryParam(value="alertIds") String var1, @QueryParam(value="tags") String var2);

    @DELETE
    @Path(value="/{alertId}")
    public Response deleteAlert(@PathParam(value="alertId") String var1);
}

