/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.alert.jaxrs.handlers;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.json.GroupConditionsInfo;
import org.hawkular.alerts.api.json.GroupMemberInfo;
import org.hawkular.alerts.api.json.UnorphanMemberInfo;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;

@Path(value="/hawkular/alerts/triggers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface TriggersHandler {
    @GET
    @Path(value="/")
    public Response findTriggers(@QueryParam(value="triggerIds") String var1, @QueryParam(value="tags") String var2, @QueryParam(value="thin") Boolean var3);

    @POST
    @Path(value="/")
    public Response createTrigger(Trigger var1);

    @POST
    @Path(value="/groups")
    public Response createGroupTrigger(Trigger var1);

    @POST
    @Path(value="/groups/members")
    public Response createGroupMember(GroupMemberInfo var1);

    @POST
    @Path(value="/groups/members/{memberId}/orphan")
    public Response orphanMemberTrigger(@PathParam(value="memberId") String var1);

    @POST
    @Path(value="/groups/members/{memberId}/unorphan")
    public Response unorphanMemberTrigger(@PathParam(value="memberId") String var1, UnorphanMemberInfo var2);

    @DELETE
    @Path(value="/groups/{groupId}")
    public Response deleteGroupTrigger(@PathParam(value="groupId") String var1, @QueryParam(value="keepNonOrphans") boolean var2, @QueryParam(value="keepOrphans") boolean var3);

    @PUT
    @Path(value="/groups/{groupId}")
    public Response updateGroupTrigger(@PathParam(value="groupId") String var1, Trigger var2);

    @PUT
    @Path(value="/groups/{groupId}/conditions/{triggerMode}")
    public Response setGroupConditions(@PathParam(value="groupId") String var1, @PathParam(value="triggerMode") String var2, GroupConditionsInfo var3);

    @POST
    @Path(value="/groups/{groupId}/dampenings")
    public Response createGroupDampening(@PathParam(value="groupId") String var1, Dampening var2);

    @DELETE
    @Path(value="/groups/{groupId}/dampenings/{dampeningId}")
    public Response deleteGroupDampening(@PathParam(value="groupId") String var1, @PathParam(value="dampeningId") String var2);

    @PUT
    @Path(value="/groups/{groupId}/dampenings/{dampeningId}")
    public Response updateGroupDampening(@PathParam(value="groupId") String var1, @PathParam(value="dampeningId") String var2, Dampening var3);

    @GET
    @Path(value="/groups/{groupId}/members")
    public Response findGroupMembers(@PathParam(value="groupId") String var1, @QueryParam(value="includeOrphans") boolean var2);

    @POST
    @Path(value="/trigger")
    public Response createFullTrigger(FullTrigger var1);

    @GET
    @Path(value="/trigger/{triggerId}")
    public Response getFullTriggerById(@PathParam(value="triggerId") String var1);

    @DELETE
    @Path(value="/{triggerId}")
    public Response deleteTrigger(@PathParam(value="triggerId") String var1);

    @GET
    @Path(value="/{triggerId}")
    public Response getTrigger(@PathParam(value="triggerId") String var1);

    @PUT
    @Path(value="/{triggerId}")
    public Response updateTrigger(@PathParam(value="triggerId") String var1, Trigger var2);

    @GET
    @Path(value="/{triggerId}/conditions")
    public Response getTriggerConditions(@PathParam(value="triggerId") String var1);

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    public Response setAvailabilityCondition(@PathParam(value="triggerId") String var1, @PathParam(value="triggerMode") String var2, List<AvailabilityCondition> var3);

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    public Response setCompareCondition(@PathParam(value="triggerId") String var1, @PathParam(value="triggerMode") String var2, List<CompareCondition> var3);

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    public Response setStringCondition(@PathParam(value="triggerId") String var1, @PathParam(value="triggerMode") String var2, List<StringCondition> var3);

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    public Response setThresholdCondition(@PathParam(value="triggerId") String var1, @PathParam(value="triggerMode") String var2, List<ThresholdCondition> var3);

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    public Response setThresholdRangeCondition(@PathParam(value="triggerId") String var1, @PathParam(value="triggerMode") String var2, List<ThresholdRangeCondition> var3);

    @GET
    @Path(value="/{triggerId}/dampenings")
    public Response getTriggerDampenings(@PathParam(value="triggerId") String var1);

    @POST
    @Path(value="/{triggerId}/dampenings")
    public Response createDampening(@PathParam(value="triggerId") String var1, Dampening var2);

    @GET
    @Path(value="/{triggerId}/dampenings/mode/{triggerMode}")
    public Response getTriggerModeDampenings(@PathParam(value="triggerId") String var1, @PathParam(value="triggerMode") Mode var2);

    @DELETE
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    public Response deleteDampening(@PathParam(value="triggerId") String var1, @PathParam(value="dampeningId") String var2);

    @GET
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    public Response getDampening(@PathParam(value="triggerId") String var1, @PathParam(value="dampeningId") String var2);

    @PUT
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    public Response updateDampening(@PathParam(value="triggerId") String var1, @PathParam(value="dampeningId") String var2, Dampening var3);
}

