/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core;

import com.google.common.base.Preconditions;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.core.jaxrs.RestFactory;
import org.hawkular.client.core.typeresolvers.CollectionJavaTypeResolver;
import org.hawkular.client.core.typeresolvers.MapJavaTypeResolver;
import org.hawkular.client.core.typeresolvers.SimpleJavaTypeResolver;

public abstract class BaseClient<T> {
    private T restAPI;
    private SimpleJavaTypeResolver simpleJavaTypeResolver = new SimpleJavaTypeResolver();
    private CollectionJavaTypeResolver collectionJavaTypeResolver = new CollectionJavaTypeResolver();
    private MapJavaTypeResolver mapJavaTypeResolver = new MapJavaTypeResolver();

    public BaseClient(ClientInfo clientInfo, RestFactory<T> restFactory) {
        Preconditions.checkNotNull((Object)clientInfo);
        this.restAPI = restFactory.createAPI(clientInfo);
    }

    public T restApi() {
        return this.restAPI;
    }

    public SimpleJavaTypeResolver simpleResolver() {
        return this.simpleJavaTypeResolver;
    }

    public CollectionJavaTypeResolver collectionResolver() {
        return this.collectionJavaTypeResolver;
    }

    public MapJavaTypeResolver mapResolver() {
        return this.mapJavaTypeResolver;
    }
}

