/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.hawkular.client.core.ClientResponse;
import org.hawkular.client.core.jaxrs.Empty;
import org.hawkular.client.core.jaxrs.ResponseCodes;
import org.hawkular.client.core.jaxrs.fasterxml.jackson.ClientObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientResponse<T>
implements ClientResponse<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientResponse.class);
    private int statusCode;
    private String errorMsg;
    private T entity;
    private boolean isSuccess = false;
    private String rawEntity;
    private final JavaType javaType;
    private final ResponseCodes expectedCode;

    public DefaultClientResponse() {
        this.javaType = null;
        this.expectedCode = ResponseCodes.NO_CONTENT_204;
    }

    public DefaultClientResponse(JavaType javaType, Response serverResponse, ResponseCodes expectedCode) {
        this.javaType = javaType;
        this.expectedCode = expectedCode;
        this.validateResponse(serverResponse, expectedCode);
    }

    private void validateResponse(Response serverResponse, ResponseCodes expectedCode) {
        try {
            this.setStatusCode(serverResponse.getStatus());
            this.setSuccess(expectedCode.value() == serverResponse.getStatus());
            this.setRawEntity((String)serverResponse.readEntity(String.class));
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Client Response: {}", (Object)this.toString());
            }
        }
    }

    private void parse() {
        if (this.isSuccess()) {
            if (!this.javaType.getRawClass().isAssignableFrom(Empty.class)) {
                try {
                    ClientObjectMapper objectMapper = new ClientObjectMapper();
                    this.setEntity(objectMapper.readValue(this.getRawEntity(), this.javaType));
                }
                catch (IOException ex) {
                    LOG.error("Failed to parse: {}", (Throwable)ex);
                    this.setErrorMsg("Failed to parse: " + ex.toString());
                    this.setSuccess(Boolean.FALSE);
                }
            }
        } else {
            this.setErrorMsg("Expected code '" + this.expectedCode.toString() + "' but got '" + this.getStatusCode() + "'");
        }
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    @Override
    public T getEntity() {
        if (this.entity == null) {
            this.parse();
        }
        return this.entity;
    }

    @Override
    public void setEntity(T entity) {
        this.entity = entity;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getRawEntity() {
        return this.rawEntity;
    }

    public void setRawEntity(String rawEntity) {
        this.rawEntity = rawEntity;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Status Code:").append(this.getStatusCode()).append(", Is Success:").append(this.isSuccess()).append(", Error Message:").append(this.getErrorMsg() == null ? "-" : this.getErrorMsg()).append(", Raw Entity:").append(this.getRawEntity());
        if (this.getEntity() instanceof Object[]) {
            builder.append(", Entity:").append(Arrays.toString((Object[])this.getEntity()));
        } else {
            builder.append(", Entity:[").append(this.getEntity()).append("]");
        }
        return builder.toString();
    }
}

