/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core;

import com.google.common.base.Throwables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.core.HawkularClient;

public class HawkularClientBuilder {
    private URI uri;
    private Optional<String> username = Optional.empty();
    private Optional<String> password = Optional.empty();
    private Map<String, Object> headers = new HashMap<String, Object>();

    public HawkularClientBuilder(String tenant) {
        try {
            this.uri = new URI("http://127.0.0.1:8080");
        }
        catch (URISyntaxException e) {
            Throwables.propagate((Throwable)e);
        }
        this.headers.put("Hawkular-Tenant", tenant);
    }

    public HawkularClientBuilder uri(String uri) throws URISyntaxException {
        return this.uri(new URI(uri));
    }

    public HawkularClientBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public HawkularClientBuilder basicAuthentication(String username, String password) {
        this.username = Optional.ofNullable(username);
        this.password = Optional.ofNullable(password);
        return this;
    }

    public HawkularClientBuilder basicAuthentication(Optional<String> username, Optional<String> password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public HawkularClientBuilder tokenAuthentication(String token) {
        this.headers.put("Authorization", "Bearer " + token);
        return this;
    }

    public HawkularClientBuilder adminTokenAuthentication(String token) {
        this.headers.put("Hawkular-Admin-Token", token);
        return this;
    }

    public HawkularClientBuilder addHeader(String key, Object value) {
        this.headers.put(key, value);
        return this;
    }

    public HawkularClient build() {
        ClientInfo clientInfo = new ClientInfo(this.uri, this.username, this.password, this.headers);
        return new HawkularClient(clientInfo);
    }
}

