/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.inventory.clients;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hawkular.client.core.BaseClient;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.core.ClientResponse;
import org.hawkular.client.core.DefaultClientResponse;
import org.hawkular.client.core.jaxrs.ResponseCodes;
import org.hawkular.client.core.jaxrs.RestFactory;
import org.hawkular.client.inventory.clients.TraversalClient;
import org.hawkular.client.inventory.jaxrs.handlers.TraversalHandler;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

public class DefaultTraversalClient
extends BaseClient<TraversalHandler>
implements TraversalClient {
    public DefaultTraversalClient(ClientInfo clientInfo) {
        super(clientInfo, new RestFactory<TraversalHandler>(TraversalHandler.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponse<List<Map>> getTraversal(CanonicalPath traversal, String at, Integer page, Integer per_page, String sort, Order.Direction order, SegmentType type, String id, String name, CanonicalPath cp, String propertyName, String propertyValue, Relationships.WellKnown relatedBy, CanonicalPath relatedTo, CanonicalPath relatedWith, String definedBy) {
        try (Response serverResponse = null;){
            String filter = this.getFilter(type, id, name, cp, propertyName, propertyValue, relatedBy, relatedTo, relatedWith, definedBy);
            serverResponse = ((TraversalHandler)this.restApi()).getTraversal(traversal.toRelativePath().toString(), at, page, per_page, sort, order.getShortString(), filter);
            JavaType javaType = this.collectionResolver().get(List.class, Map.class);
            DefaultClientResponse<List<Map>> defaultClientResponse = new DefaultClientResponse<List<Map>>(javaType, serverResponse, ResponseCodes.GET_SUCCESS_200);
            return defaultClientResponse;
        }
    }

    private String getFilter(SegmentType type, String id, String name, CanonicalPath cp, String propertyName, String propertyValue, Relationships.WellKnown relatedBy, CanonicalPath relatedTo, CanonicalPath relatedWith, String definedBy) {
        StringBuilder filter = new StringBuilder();
        if (type != null) {
            filter.append("type=" + type.getSerialized() + ";");
        }
        if (!Strings.isNullOrEmpty((String)id)) {
            filter.append("id=" + id + ";");
        }
        if (!Strings.isNullOrEmpty((String)name)) {
            filter.append("name=" + name + ";");
        }
        if (cp != null) {
            filter.append("cp=" + cp.toString() + ";");
        }
        if (!Strings.isNullOrEmpty((String)propertyName)) {
            filter.append("propertyName=" + propertyName + ";");
        }
        if (!Strings.isNullOrEmpty((String)propertyValue)) {
            filter.append("propertyValue=" + propertyValue + ";");
        }
        if (relatedBy != null) {
            filter.append("relatedBy=" + relatedBy.name() + ";");
        }
        if (relatedTo != null) {
            filter.append("relatedTo=" + relatedTo.toString() + ";");
        }
        if (relatedWith != null) {
            filter.append("relatedWith=" + relatedWith.toString() + ";");
        }
        if (definedBy != null) {
            filter.append("definedBy=" + definedBy + ";");
        }
        if (filter.length() > 0) {
            filter.setLength(filter.length() - 1);
        }
        return filter.toString();
    }
}

