/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.inventory.model;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JaxRsResource
implements Comparable<JaxRsResource> {
    private static final Pattern NAME_PATTERN = Pattern.compile("(/[a-zA-Z]+)");
    private Set<String> methods = new HashSet<String>();
    private String uri;

    public JaxRsResource() {
    }

    public JaxRsResource(String uri) {
        this.uri = uri;
    }

    public boolean addMethod(String method) {
        return this.methods.add(method);
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    private String getUriPattern(String uri) {
        Matcher matcher = NAME_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group();
        }
        return uri;
    }

    @Override
    public int compareTo(JaxRsResource that) {
        if (this == that) {
            return 0;
        }
        String other = this.getUriPattern(that.getUri());
        String current = this.getUriPattern(this.uri);
        return current.compareTo(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JaxRsResource)) {
            return false;
        }
        JaxRsResource that = (JaxRsResource)o;
        return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri));
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }
}

