/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.metrics.fasterxml.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.metrics.model.AvailabilityBucketPoint;

public class AvailabilityBucketPointDeserializer
extends JsonDeserializer<AvailabilityBucketPoint> {
    public AvailabilityBucketPoint deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec objectCodec = jp.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(jp);
        long start = 0L;
        JsonNode startJsonNode = node.get("start");
        if (startJsonNode != null) {
            start = startJsonNode.asLong();
        }
        long end = 0L;
        JsonNode endJsonNode = node.get("end");
        if (endJsonNode != null) {
            end = endJsonNode.asLong();
        }
        JsonNode durationMapJsonNode = node.get("durationMap");
        JsonNode lastNotUptimeJsonNode = node.get("lastNotUptime");
        JsonNode uptimeRatioJsonNode = node.get("uptimeRatio");
        JsonNode notUpCountJsonNode = node.get("notUpCount");
        JsonNode adminDurationJsonNode = node.get("adminDuration");
        JsonNode downDurationJsonNode = node.get("downDuration");
        return new AvailabilityBucketPoint.Builder(start, end).setDurationMap(durationMapJsonNode == null ? new HashMap() : (Map)objectCodec.treeToValue((TreeNode)durationMapJsonNode, Map.class)).setAdminDuration(adminDurationJsonNode == null ? 0L : adminDurationJsonNode.asLong()).setLastNotUptime(lastNotUptimeJsonNode == null ? 0L : lastNotUptimeJsonNode.asLong()).setDownDuration(downDurationJsonNode == null ? 0L : downDurationJsonNode.asLong()).setUptimeRatio(uptimeRatioJsonNode == null ? 0.0 : (double)uptimeRatioJsonNode.asLong()).setNotUptimeCount(notUpCountJsonNode == null ? 0L : notUpCountJsonNode.asLong()).build();
    }
}

