/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.metrics.fasterxml.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.metrics.model.NumericBucketPoint;

public class NumericBucketPointDeserializer
extends JsonDeserializer<NumericBucketPoint> {
    public NumericBucketPoint deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec objectCodec = jp.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(jp);
        long start = 0L;
        JsonNode startJsonNode = node.get("start");
        if (startJsonNode != null) {
            start = startJsonNode.asLong();
        }
        long end = 0L;
        JsonNode endJsonNode = node.get("end");
        if (endJsonNode != null) {
            end = endJsonNode.asLong();
        }
        JsonNode minJsonNode = node.get("min");
        JsonNode avgJsonNode = node.get("avg");
        JsonNode medianJsonNode = node.get("median");
        JsonNode maxJsonNode = node.get("max");
        JsonNode sumJsonNode = node.get("sum");
        JsonNode samplesJsonNode = node.get("samples");
        JsonNode percentilesJsonNode = node.get("percentiles");
        List percentiles = new ArrayList();
        if (percentilesJsonNode != null) {
            percentiles = (List)objectCodec.treeToValue((TreeNode)percentilesJsonNode, List.class);
        }
        return new NumericBucketPoint.Builder(start, end).setMin(minJsonNode == null ? 0.0 : minJsonNode.asDouble()).setAvg(avgJsonNode == null ? 0.0 : avgJsonNode.asDouble()).setMedian(medianJsonNode == null ? 0.0 : medianJsonNode.asDouble()).setMax(maxJsonNode == null ? 0.0 : maxJsonNode.asDouble()).setSum(sumJsonNode == null ? 0.0 : sumJsonNode.asDouble()).setSamples(samplesJsonNode == null ? 0 : samplesJsonNode.asInt()).setPercentiles(percentiles).build();
    }
}

