/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.metrics.fasterxml.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.metrics.model.TaggedBucketPoint;

public class TaggedBucketPointDeserializer
extends JsonDeserializer<TaggedBucketPoint> {
    public TaggedBucketPoint deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec objectCodec = jp.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(jp);
        JsonNode tagsJsonNode = node.get("tags");
        JsonNode minJsonNode = node.get("min");
        JsonNode avgJsonNode = node.get("avg");
        JsonNode medianJsonNode = node.get("median");
        JsonNode maxJsonNode = node.get("max");
        JsonNode sumJsonNode = node.get("sum");
        JsonNode samplesJsonNode = node.get("samples");
        JsonNode percentilesJsonNode = node.get("percentiles");
        List percentiles = new ArrayList();
        if (percentilesJsonNode != null) {
            percentiles = (List)objectCodec.treeToValue((TreeNode)percentilesJsonNode, List.class);
        }
        return new TaggedBucketPoint(tagsJsonNode == null ? new HashMap() : (Map)objectCodec.treeToValue((TreeNode)tagsJsonNode, Map.class), minJsonNode == null ? 0.0 : minJsonNode.asDouble(), avgJsonNode == null ? 0.0 : avgJsonNode.asDouble(), medianJsonNode == null ? 0.0 : medianJsonNode.asDouble(), maxJsonNode == null ? 0.0 : maxJsonNode.asDouble(), sumJsonNode == null ? 0.0 : sumJsonNode.asDouble(), samplesJsonNode == null ? 0 : samplesJsonNode.asInt(), percentiles);
    }
}

