/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.metrics.jaxrs.handlers;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.client.metrics.model.Order;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Percentiles;
import org.hawkular.metrics.model.param.Tags;

@Path(value="/hawkular/metrics/counters")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface CounterHandler {
    @GET
    @Path(value="/")
    public Response getCounters(@QueryParam(value="tags") Tags var1);

    @POST
    @Path(value="/")
    public Response createCounter(@QueryParam(value="overwrite") Boolean var1, Metric<Long> var2);

    @GET
    @Path(value="/rate/stats")
    public Response findCounterRateDataStats(@QueryParam(value="start") String var1, @QueryParam(value="end") String var2, @QueryParam(value="buckets") Integer var3, @QueryParam(value="bucketDuration") Duration var4, @QueryParam(value="percentiles") Percentiles var5, @QueryParam(value="tags") Tags var6, @QueryParam(value="metrics") List<String> var7, @QueryParam(value="stacked") Boolean var8);

    @POST
    @Path(value="/raw")
    public Response addCounterData(List<Metric<Long>> var1);

    @GET
    @Path(value="/stats")
    public Response findCounterStats(@QueryParam(value="start") String var1, @QueryParam(value="end") String var2, @QueryParam(value="buckets") Integer var3, @QueryParam(value="bucketDuration") Duration var4, @QueryParam(value="percentiles") Percentiles var5, @QueryParam(value="tags") Tags var6, @QueryParam(value="metrics") List<String> var7, @QueryParam(value="stacked") Boolean var8);

    @GET
    @Path(value="/tags/{tags}")
    public Response findCounterMetrics(@PathParam(value="tags") Tags var1);

    @GET
    @Path(value="/{id}")
    public Response getCounter(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/rate")
    public Response findCounterRate(@PathParam(value="id") String var1, @QueryParam(value="start") String var2, @QueryParam(value="end") String var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="order") Order var5, @QueryParam(value="buckets") Integer var6, @QueryParam(value="bucketDuration") Duration var7, @QueryParam(value="percentiles") Percentiles var8);

    @GET
    @Path(value="/{id}/rate/stats")
    public Response findCounterRateStats(@PathParam(value="id") String var1, @QueryParam(value="start") String var2, @QueryParam(value="end") String var3, @QueryParam(value="buckets") Integer var4, @QueryParam(value="bucketDuration") Duration var5, @QueryParam(value="percentiles") Percentiles var6);

    @GET
    @Path(value="/{id}/raw")
    public Response findCounterData(@PathParam(value="id") String var1, @QueryParam(value="start") String var2, @QueryParam(value="end") String var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="order") Order var5);

    @POST
    @Path(value="/{id}/raw")
    public Response createCounterData(@PathParam(value="id") String var1, List<DataPoint<Long>> var2);

    @GET
    @Path(value="/{id}/stats")
    public Response findCounterMetricStats(@PathParam(value="id") String var1, @QueryParam(value="start") String var2, @QueryParam(value="end") String var3, @QueryParam(value="fromEarliest") Boolean var4, @QueryParam(value="buckets") Integer var5, @QueryParam(value="bucketDuration") Duration var6, @QueryParam(value="percentiles") Percentiles var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="order") Order var9);

    @GET
    @Path(value="/{id}/stats/tags/{tags}")
    public Response getCounterMetricStatsTags(@PathParam(value="id") String var1, @PathParam(value="tags") Tags var2, @QueryParam(value="start") String var3, @QueryParam(value="end") String var4, @QueryParam(value="percentiles") Percentiles var5);

    @GET
    @Path(value="/{id}/tags")
    public Response getCounterMetricTags(@PathParam(value="id") String var1);

    @PUT
    @Path(value="/{id}/tags")
    public Response updateCountersMetricTags(@PathParam(value="id") String var1, Map<String, String> var2);

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    public Response deleteCounterMetricTags(@PathParam(value="id") String var1, @PathParam(value="tags") Tags var2);
}

