/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.paths;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum SegmentType {
    t("Tenant"),
    e("Environment"),
    f("Feed"),
    m("Metric"),
    r("Resource"),
    rt("ResourceType"),
    mt("MetricType"),
    rl("Relationship"),
    d("DataEntity"),
    ot("OperationType"),
    mp("MetadataPack"),
    sd("StructuredData"){

        @Override
        public boolean isSerializable() {
            return false;
        }
    }
    ,
    up("Up", ".."){

        @Override
        public boolean isAllowedInCanonical() {
            return false;
        }
    };

    private static final Map<String, SegmentType> entriesByShortName;
    private static final Map<String, SegmentType> entriesBySimpleName;
    private static final Set<String> canonicalShortNames;
    private static final Set<SegmentType> relativeShortNames;
    public static final SegmentType ANY_ENTITY;
    private final String simpleName;
    private final String serialized;

    private SegmentType(String simpleName) {
        this.simpleName = simpleName;
        this.serialized = this.name();
    }

    private SegmentType(String simpleName, String serialized) {
        this.simpleName = simpleName;
        this.serialized = serialized;
    }

    public static SegmentType fastValueOf(String type) {
        return entriesByShortName.get(type);
    }

    public static SegmentType fromElementType(Class<?> elementType) {
        return elementType == null ? null : entriesBySimpleName.get(elementType.getSimpleName());
    }

    public static Set<String> getCanonicalShortNames() {
        return canonicalShortNames;
    }

    public static Set<SegmentType> getRelativeShortNames() {
        return relativeShortNames;
    }

    public boolean isAllowedInCanonical() {
        return true;
    }

    public boolean isSerializable() {
        return true;
    }

    public String getSerialized() {
        return this.serialized;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    static {
        ANY_ENTITY = null;
        HashMap<String, SegmentType> tmpByShortName = new HashMap<String, SegmentType>();
        HashMap<String, SegmentType> tmpBySimpleName = new HashMap<String, SegmentType>();
        HashSet<String> canonicalTmp = new HashSet<String>();
        HashSet<SegmentType> relativeTmp = new HashSet<SegmentType>();
        for (SegmentType segmentType : SegmentType.values()) {
            tmpByShortName.put(segmentType.name(), segmentType);
            tmpBySimpleName.put(segmentType.getSimpleName(), segmentType);
            if (segmentType.isAllowedInCanonical()) {
                canonicalTmp.add(segmentType.name());
            }
            relativeTmp.add(segmentType);
        }
        tmpByShortName.put(SegmentType.up.serialized, up);
        entriesByShortName = Collections.unmodifiableMap(tmpByShortName);
        entriesBySimpleName = Collections.unmodifiableMap(tmpBySimpleName);
        canonicalShortNames = Collections.unmodifiableSet(canonicalTmp);
        relativeShortNames = Collections.unmodifiableSet(relativeTmp);
    }
}

