/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hawkular.commons.log.MsgLogger;
import org.hawkular.commons.log.MsgLogging;
import org.hawkular.commons.properties.HawkularProperties;
import org.hawkular.handlers.BaseApplication;
import org.hawkular.handlers.RestEndpoint;
import org.hawkular.handlers.RestHandler;

public class HandlersManager {
    private static final MsgLogger log = MsgLogging.getMsgLogger(HandlersManager.class);
    private static final String CORS_ORIGIN_PATTERN = "hawkular.cors-origin-pattern";
    private static final String CORS_ORIGIN_PATTERN_DEFAULT = "*";
    private static final String CORS_HEADERS = "hawkular.cors-headers";
    private static final String CORS_HEADERS_DEFAULT = "origin,accept,content-type,hawkular-tenant";
    private static final String CORS_METHODS = "hawkular.cors-methods";
    private static final String CORS_METHODS_DEFAULT = "GET,POST,PUT,PATCH,DELETE,OPTIONS,HEAD";
    private Router router;
    private Map<String, BaseApplication> applications = new HashMap<String, BaseApplication>();
    private Map<String, Class<BaseApplication>> applicationsClasses = new HashMap<String, Class<BaseApplication>>();
    private Map<EndpointKey, RestHandler> endpoints = new HashMap<EndpointKey, RestHandler>();
    private Map<EndpointKey, Class<RestHandler>> endpointsClasses = new HashMap<EndpointKey, Class<RestHandler>>();
    private ClassLoader cl = Thread.currentThread().getContextClassLoader();
    private String corsAllowedOriginPattern;
    private String corsHeaders;
    private String corsMethods;

    public HandlersManager(Vertx vertx) {
        this.router = Router.router((Vertx)vertx);
        this.corsAllowedOriginPattern = HawkularProperties.getProperty((String)CORS_ORIGIN_PATTERN, (String)CORS_ORIGIN_PATTERN_DEFAULT);
        this.corsHeaders = HawkularProperties.getProperty((String)CORS_HEADERS, (String)CORS_HEADERS_DEFAULT);
        this.corsMethods = HawkularProperties.getProperty((String)CORS_METHODS, (String)CORS_METHODS_DEFAULT);
    }

    public void start() {
        try {
            this.scan();
            log.info((Object)"Rest Handlers scan finished");
            this.applicationsClasses.entrySet().stream().forEach(appClass -> {
                try {
                    BaseApplication app = (BaseApplication)((Class)appClass.getValue()).newInstance();
                    log.infof("Starting App [ %s ] - BaseUrl [ %s ]", appClass.getKey(), (Object)app.baseUrl());
                    app.start();
                    this.applications.put((String)appClass.getKey(), app);
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "Error loading App [%s]", appClass);
                }
            });
            this.endpointsClasses.entrySet().stream().forEach(endpoint -> {
                try {
                    String endpointPackage = ((Class)endpoint.getValue()).getPackage().getName();
                    BaseApplication app = null;
                    while (endpointPackage.length() != 0 && (app = this.applications.get(endpointPackage)) == null && endpointPackage.lastIndexOf(46) != -1) {
                        endpointPackage = endpointPackage.substring(0, endpointPackage.lastIndexOf(46));
                    }
                    if (app == null) {
                        log.errorf("Handler [%s] does not belong to an application.", (Object)((Class)endpoint.getValue()).getName());
                        return;
                    }
                    String baseUrl = app.baseUrl();
                    this.router.route(baseUrl + CORS_ORIGIN_PATTERN_DEFAULT).handler((Handler)BodyHandler.create());
                    if (this.corsAllowedOriginPattern.length() > 0) {
                        CorsHandler corsHandler = CorsHandler.create((String)this.corsAllowedOriginPattern);
                        if (this.corsHeaders.length() > 0) {
                            corsHandler.allowedHeaders(this.extractCorsHeaders(this.corsHeaders));
                        }
                        if (this.corsMethods.length() > 0) {
                            corsHandler.allowedMethods(this.extractCorsMethods(this.corsMethods));
                        }
                        this.router.route(baseUrl + CORS_ORIGIN_PATTERN_DEFAULT).handler((Handler)corsHandler);
                    }
                    RestHandler handler = (RestHandler)((Class)endpoint.getValue()).newInstance();
                    handler.initRoutes(baseUrl, this.router);
                    this.endpoints.put((EndpointKey)endpoint.getKey(), handler);
                    log.infof("Starting on [ %s ]: Endpoint [ %s ] - Handler [ %s ]", (Object)baseUrl, (Object)((EndpointKey)endpoint.getKey()).getEndpoint(), (Object)((Class)endpoint.getValue()).getName());
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "Error loading Handler [%s]", endpoint);
                }
            });
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void handle(HttpServerRequest req) {
        log.debugf("%s %s %s", (Object)req.method().name(), (Object)req.path(), (Object)req.params());
        this.router.accept(req);
    }

    public void stop() {
        this.applications.entrySet().stream().forEach(application -> ((BaseApplication)application.getValue()).stop());
    }

    private void scan() throws IOException {
        ArrayList<String> pathsToProcess = new ArrayList<String>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL[] classLoaderPaths = ((URLClassLoader)classLoader).getURLs();
        for (int i = 0; i < classLoaderPaths.length; ++i) {
            pathsToProcess.add(classLoaderPaths[i].getPath());
        }
        String[] classpath = System.getProperty("java.class.path").split(":");
        for (int i = 0; i < classpath.length; ++i) {
            pathsToProcess.add(classpath[i]);
        }
        for (String fullFileName : pathsToProcess) {
            File file = new File(fullFileName);
            String fileName = file.getName();
            if (file.isDirectory()) {
                this.processDirectory(fullFileName, fullFileName.length());
                continue;
            }
            if (!fileName.contains("hawkular") || !fileName.endsWith("jar")) continue;
            this.processArchive(fullFileName);
        }
    }

    private void processArchive(String path) throws IOException, FileNotFoundException {
        log.debug((Object)path);
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(path));){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class") && entry.getName().contains("hawkular")) {
                    this.processClass(entry.getName());
                }
                entry = zip.getNextEntry();
            }
        }
    }

    public void processDirectory(String directoryName, int rootLength) {
        log.debug((Object)directoryName);
        File directory = new File(directoryName);
        for (File file : directory.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".class")) {
                this.processClass(file.getPath().substring(rootLength));
                continue;
            }
            if (!file.isDirectory()) continue;
            this.processDirectory(file.getAbsolutePath(), rootLength);
        }
    }

    private void processClass(String className) {
        className = className.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        log.debug((Object)className);
        try {
            Class<?> clazz = this.cl.loadClass(className);
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                if (!interfaces[j].equals(BaseApplication.class)) continue;
                String appName = clazz.getPackage().getName();
                this.applicationsClasses.put(appName, clazz);
            }
            if (clazz.isAnnotationPresent(RestEndpoint.class)) {
                RestEndpoint endpoint = clazz.getAnnotation(RestEndpoint.class);
                for (int j = 0; j < interfaces.length; ++j) {
                    if (!interfaces[j].equals(RestHandler.class)) continue;
                    this.endpointsClasses.put(new EndpointKey(endpoint.path(), clazz.getCanonicalName()), clazz);
                }
            }
        }
        catch (Error | Exception e) {
            log.errorf(e, "Error loading Handler [%s].", (Object)className);
            System.exit(1);
        }
    }

    private Set<String> extractCorsHeaders(String corsHeaders) {
        HashSet<String> headers = new HashSet<String>();
        if (corsHeaders != null && corsHeaders.length() > 0) {
            String[] splitted = corsHeaders.split(",");
            for (int i = 0; i < splitted.length; ++i) {
                headers.add(splitted[i]);
            }
        }
        return headers;
    }

    private Set<HttpMethod> extractCorsMethods(String corsMethods) {
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        if (corsMethods != null && corsMethods.length() > 0) {
            String[] splitted = corsMethods.split(",");
            for (int i = 0; i < splitted.length; ++i) {
                try {
                    methods.add(HttpMethod.valueOf((String)splitted[i]));
                    continue;
                }
                catch (Exception e) {
                    log.warnf("Skipping unknown CORS method [%s]: %s", (Object)splitted[i], (Object)e.getMessage());
                }
            }
        }
        return methods;
    }

    public static class EndpointKey {
        private String endpoint;
        private String className;

        public EndpointKey(String endpoint, String className) {
            this.endpoint = endpoint;
            this.className = className;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointKey that = (EndpointKey)o;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) {
                return false;
            }
            return this.className != null ? this.className.equals(that.className) : that.className == null;
        }

        public int hashCode() {
            int result = this.endpoint != null ? this.endpoint.hashCode() : 0;
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            return result;
        }
    }
}

