/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.util.Map;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.inventory.api.model.Resource;

public class PingDestination {
    public static final String URL_TYPE = "URL";
    public static final String DEFAULT_METHOD = "GET";
    private final String tenantId;
    private final String environmentId;
    private final String resourceId;
    private final String url;
    private final String method;

    public static boolean isUrl(Resource r) {
        return URL_TYPE.equals(r.getType().getId());
    }

    public static PingDestination from(Resource r) {
        Map props = r.getProperties();
        return new PingDestination(r.getPath().ids().getTenantId(), r.getPath().ids().getEnvironmentId(), r.getId(), (String)props.get(ResourceField.url.name()), (String)props.get(ResourceField.method.name()));
    }

    public PingDestination(String tenantId, String environmentId, String resourceId, String url) {
        this(tenantId, environmentId, resourceId, url, DEFAULT_METHOD);
    }

    public PingDestination(String tenantId, String environmentId, String resourceId, String url, String method) {
        this.tenantId = tenantId;
        this.environmentId = environmentId;
        this.resourceId = resourceId;
        this.url = url;
        this.method = method == null ? DEFAULT_METHOD : method;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.environmentId == null ? 0 : this.environmentId.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PingDestination other = (PingDestination)obj;
        if (this.environmentId == null ? other.environmentId != null : !this.environmentId.equals(other.environmentId)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "PingDestination{tenantId='" + this.tenantId + '\'' + "environmentId='" + this.environmentId + '\'' + "resourceId='" + this.resourceId + '\'' + ", url='" + this.url + '\'' + ", method='" + this.method + '\'' + '}';
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }
}

