/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.PingStatus;
import org.hawkular.component.pinger.Pinger;
import org.hawkular.component.pinger.Traits;

@Stateless
public class Pinger {
    static final String REMOTE_ADDRESS_ATTRIBUTE = Pinger.class.getPackage().getName() + ".remoteAddress";
    private final HttpClientConnectionManager connectionManager = this.createConnectionManager();
    private final CloseableHttpClient client = HttpClientBuilder.create().setConnectionManager(this.connectionManager).build();

    private HttpClientConnectionManager createConnectionManager() {
        SSLContext tmpSslContext;
        1 plainSf = new /* Unavailable Anonymous Inner Class!! */;
        try {
            SSLContextBuilder builder = SSLContexts.custom();
            builder.loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */);
            tmpSslContext = builder.build();
        }
        catch (Exception e) {
            tmpSslContext = null;
        }
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(tmpSslContext, null, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)plainSf).register("https", (Object)sslSocketFactory).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Asynchronous
    public Future<PingStatus> ping(PingDestination destination) {
        Log.LOG.debugf("About to ping %s", (Object)destination.getUrl());
        HttpUriRequest request = RequestBuilder.create((String)destination.getMethod()).setUri(destination.getUrl()).build();
        try {
            long start = System.currentTimeMillis();
            HttpClientContext context = HttpClientContext.create();
            try (CloseableHttpResponse httpResponse = this.client.execute(request, (HttpContext)context);){
                InetAddress remoteAddress = (InetAddress)context.getAttribute(REMOTE_ADDRESS_ATTRIBUTE);
                StatusLine statusLine = httpResponse.getStatusLine();
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                long now = System.currentTimeMillis();
                int code = statusLine.getStatusCode();
                int duration = (int)(now - start);
                Traits traits = Traits.collect((HttpResponse)httpResponse, (long)now, (InetAddress)remoteAddress);
                PingStatus result = new PingStatus(destination, code, now, duration, traits);
                Log.LOG.debugf("Got status code %d from %s", code, (Object)destination.getUrl());
                AsyncResult asyncResult = new AsyncResult((Object)result);
                return asyncResult;
            }
        }
        catch (UnknownHostException e) {
            PingStatus result = PingStatus.error((PingDestination)destination, (int)404, (long)System.currentTimeMillis());
            Log.LOG.debugf("Got UnknownHostException for %s", (Object)destination.getUrl());
            return new AsyncResult((Object)result);
        }
        catch (IOException e) {
            Log.LOG.dCouldNotPingUrl(destination.getUrl(), (Throwable)e);
            PingStatus result = PingStatus.error((PingDestination)destination, (int)500, (long)System.currentTimeMillis());
            return new AsyncResult((Object)result);
        }
    }
}

