/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.PingStatus;
import org.hawkular.component.pinger.Traits;

@Stateless
public class Pinger {
    private final SSLContext sslContext;

    public Pinger() throws Exception {
        SSLContext tmpSslContext;
        try {
            SSLContextBuilder builder = SSLContexts.custom();
            builder.loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */);
            tmpSslContext = builder.build();
        }
        catch (Exception e) {
            tmpSslContext = null;
        }
        this.sslContext = tmpSslContext;
    }

    private CloseableHttpClient getHttpClient(String url) {
        if (url != null && url.startsWith("https://") && this.sslContext != null) {
            return HttpClientBuilder.create().setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).setSslcontext(this.sslContext).build();
        }
        return HttpClientBuilder.create().build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Asynchronous
    public Future<PingStatus> ping(PingDestination destination) {
        Log.LOG.debugf("About to ping %s", (Object)destination.getUrl());
        HttpUriRequest request = RequestBuilder.create((String)destination.getMethod()).setUri(destination.getUrl()).build();
        try (CloseableHttpClient client = this.getHttpClient(destination.getUrl());){
            long start = System.currentTimeMillis();
            CloseableHttpResponse httpResponse = client.execute(request);
            StatusLine statusLine = httpResponse.getStatusLine();
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            long now = System.currentTimeMillis();
            int code = statusLine.getStatusCode();
            int duration = (int)(now - start);
            Traits traits = Traits.collect((HttpResponse)httpResponse, (long)now);
            PingStatus result = new PingStatus(destination, code, now, duration, traits);
            Log.LOG.debugf("Got status code %d from %s", (Object)code, (Object)destination.getUrl());
            AsyncResult asyncResult = new AsyncResult((Object)result);
            return asyncResult;
        }
        catch (UnknownHostException e) {
            PingStatus result = PingStatus.error((PingDestination)destination, (int)404, (long)System.currentTimeMillis());
            Log.LOG.debugf("Got UnknownHostException for %s", (Object)destination.getUrl());
            return new AsyncResult((Object)result);
        }
        catch (IOException e) {
            Log.LOG.dCouldNotPingUrl(destination.getUrl(), e.getMessage());
            PingStatus result = PingStatus.error((PingDestination)destination, (int)500, (long)System.currentTimeMillis());
            return new AsyncResult((Object)result);
        }
    }
}

