/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.hawkular.component.pinger.Traits;

/*
 * Exception performing whole class analysis ignored.
 */
public class Traits {
    private static final Map<TraitHeader, String> NO_ITEMS = Collections.emptyMap();
    private final Map<TraitHeader, String> items;
    private final long timestamp;

    public static Traits collect(HttpResponse httpResponse, long timestamp) {
        HashMap<TraitHeader, String> items = null;
        HashMap<TraitHeader, TreeSet<String>> multiItems = null;
        HeaderIterator headers = httpResponse.headerIterator();
        while (headers.hasNext()) {
            TreeSet<String> multiValues;
            Header header = headers.nextHeader();
            TraitHeader traitHeader = TraitHeader.fastValueOf((String)header.getName());
            if (traitHeader == null) continue;
            if (items == null) {
                items = new HashMap<TraitHeader, String>();
                items.put(traitHeader, header.getValue());
                continue;
            }
            String value = (String)items.get(traitHeader);
            if (value == null) {
                items.put(traitHeader, header.getValue());
                continue;
            }
            if (multiItems == null) {
                multiItems = new HashMap<TraitHeader, TreeSet<String>>();
            }
            if ((multiValues = (TreeSet<String>)multiItems.get(traitHeader)) == null) {
                multiValues = new TreeSet<String>();
                multiValues.add(value);
                multiItems.put(traitHeader, multiValues);
            }
            multiValues.add(header.getValue());
        }
        if (multiItems != null) {
            for (Map.Entry en : multiItems.entrySet()) {
                StringBuilder sb = new StringBuilder();
                for (String item : (Set)en.getValue()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(item);
                }
                items.put(TraitHeader.X_POWERED_BY, sb.toString());
            }
        }
        return new Traits(timestamp, items == null ? Collections.emptyMap() : Collections.unmodifiableMap(items));
    }

    public static Traits empty(long timestamp) {
        return new Traits(timestamp, NO_ITEMS);
    }

    Traits(long timestamp, Map<TraitHeader, String> items) {
        this.timestamp = timestamp;
        this.items = items;
    }

    public Map<TraitHeader, String> getItems() {
        return this.items;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Traits other = (Traits)obj;
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "Traits [items=" + this.items + ", timestamp=" + this.timestamp + "]";
    }
}

