/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.PingStatus;
import org.hawkular.component.pinger.Traits;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.Resource;

@Stateless
public class TraitsPublisher {
    @Resource(lookup="java:global/Hawkular/Inventory")
    private Inventory inventory;

    @Asynchronous
    public void publish(PingStatus status) {
        Traits traits = status.getTraits();
        PingDestination dest = status.getDestination();
        try {
            Resources.ReadWrite resourceAccess = (Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(dest.getTenantId())).environments()).get(dest.getEnvironmentId())).feedlessResources();
            org.hawkular.inventory.api.model.Resource resource = (org.hawkular.inventory.api.model.Resource)((Resources.Single)resourceAccess.get(dest.getResourceId())).entity();
            Resource.Update.Builder updateBuilder = Resource.Update.builder();
            updateBuilder.withProperties(resource.getProperties());
            updateBuilder.withProperty("traits-collected-on", (Object)traits.getTimestamp());
            for (Map.Entry entry : traits.getItems().entrySet()) {
                updateBuilder.withProperty("trait-" + ((Traits.TraitHeader)entry.getKey()).toString(), entry.getValue());
            }
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(dest.getTenantId())).environments()).get(dest.getEnvironmentId())).feedlessResources()).update(dest.getResourceId(), (Object)updateBuilder.build());
        }
        catch (EntityNotFoundException e) {
            Log.LOG.iResourceNotFound(dest.getResourceId(), dest.getTenantId());
        }
    }
}

