/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.jms.ConnectionFactory;
import javax.jms.Topic;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.MetricDataMessage;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.PingStatus;
import org.hawkular.component.pinger.PingerConfiguration;
import org.hawkular.metrics.client.common.SingleMetric;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
public class MetricPublisher {
    @Resource(lookup="java:/topic/HawkularMetricData")
    Topic topic;
    @Resource(lookup="java:/HawkularBusConnectionFactory")
    ConnectionFactory connectionFactory;
    private final PingerConfiguration configuration = PingerConfiguration.getInstance();

    private static void addDataItem(List<Map<String, Object>> mMetrics, String resourceId, long timestamp, Number value, String name) {
        HashMap<String, Number> dataMap = new HashMap<String, Number>(2);
        dataMap.put("timestamp", timestamp);
        dataMap.put("value", value);
        ArrayList<HashMap<String, Number>> data = new ArrayList<HashMap<String, Number>>(1);
        data.add(dataMap);
        HashMap<String, Object> outer = new HashMap<String, Object>(2);
        outer.put("id", resourceId + ".status." + name);
        outer.put("data", data);
        mMetrics.add(outer);
    }

    @Asynchronous
    public void sendToMetricsViaRest(PingStatus status) {
        ArrayList mMetrics = new ArrayList();
        PingDestination dest = status.getDestination();
        String resourceId = dest.getResourceId();
        long timestamp = status.getTimestamp();
        MetricPublisher.addDataItem(mMetrics, (String)resourceId, (long)timestamp, (Number)status.getDuration(), (String)"duration");
        MetricPublisher.addDataItem(mMetrics, (String)resourceId, (long)timestamp, (Number)status.getCode(), (String)"code");
        String payload = null;
        try {
            payload = new ObjectMapper().writeValueAsString(mMetrics);
        }
        catch (JsonProcessingException e) {
            Log.LOG.eCouldNotParseMessage((Throwable)e);
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(this.configuration.getMetricsBaseUri() + "/gauges/data");
        request.addHeader("Hawkular-Tenant", status.getDestination().getTenantId());
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() > 399) {
                Log.LOG.wMetricPostStatus(response.getStatusLine().toString());
            }
        }
        catch (IOException e) {
            Log.LOG.eMetricsIoException(e);
        }
    }

    @Asynchronous
    public void publishToTopic(PingStatus status) {
        if (this.topic != null) {
            try (ConnectionContextFactory factory = new ConnectionContextFactory(this.connectionFactory);){
                ArrayList<SingleMetric> singleMetrics = new ArrayList<SingleMetric>();
                PingDestination dest = status.getDestination();
                String resourceId = dest.getResourceId();
                long timestamp = status.getTimestamp();
                SingleMetric singleMetric = new SingleMetric(resourceId + ".status.duration", timestamp, Double.valueOf(status.getDuration()));
                singleMetrics.add(singleMetric);
                singleMetric = new SingleMetric(resourceId + ".status.code", timestamp, Double.valueOf(status.getCode()));
                singleMetrics.add(singleMetric);
                MetricDataMessage.MetricData metricData = new MetricDataMessage.MetricData();
                metricData.setTenantId(status.getDestination().getTenantId());
                metricData.setData(singleMetrics);
                Endpoint endpoint = new Endpoint(Endpoint.Type.TOPIC, this.topic.getTopicName());
                ProducerConnectionContext pc = factory.createProducerConnectionContext(endpoint);
                MetricDataMessage msg = new MetricDataMessage(metricData);
                MessageProcessor processor = new MessageProcessor();
                processor.send(pc, (BasicMessage)msg);
            }
            catch (Exception e) {
                Log.LOG.eCouldNotSendMessage((Throwable)e);
            }
        } else {
            Log.LOG.wNoTopicConnection("HawkularMetricData");
        }
    }
}

