/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.MetricPublisher;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.PingStatus;
import org.hawkular.component.pinger.Pinger;
import org.hawkular.component.pinger.TraitsPublisher;
import org.hawkular.component.pinger.UrlChangesCollector;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;

@Startup
@Singleton
public class PingManager {
    private static final int ROUNDS = 15;
    private static final int WAIT_MILLIS = 500;
    private static final int TIMEOUT_MILLIS = 7500;
    @EJB
    Pinger pinger;
    private final Set<PingDestination> destinations = new HashSet();
    @EJB
    MetricPublisher metricPublisher;
    @EJB
    TraitsPublisher traitsPublisher;
    @Resource(lookup="java:global/Hawkular/Inventory")
    Inventory inventory;
    final UrlChangesCollector urlChangesCollector = new UrlChangesCollector();

    @PostConstruct
    public void startUp() {
        this.inventory.observable(Interest.in(org.hawkular.inventory.api.model.Resource.class).being(Action.created())).subscribe(this.urlChangesCollector.getUrlCreatedAction());
        this.inventory.observable(Interest.in(org.hawkular.inventory.api.model.Resource.class).being(Action.deleted())).subscribe(this.urlChangesCollector.getUrlDeletedAction());
        Set urls = ((Resources.Multiple)((Resources.Read)((ResourceTypes.Multiple)((ResourceTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).resourceTypes()).getAll(new Filter[]{With.id((String)"URL")})).resources()).getAll(new Filter[0])).entities();
        Log.LOG.iInitializedWithUrls(urls.size());
        for (org.hawkular.inventory.api.model.Resource r : urls) {
            PingDestination dest = PingDestination.from((org.hawkular.inventory.api.model.Resource)r);
            this.destinations.add(dest);
            Log.LOG.debugf("Added initial URL to ping: %s", (Object)dest.getUrl());
        }
    }

    @Lock(value=LockType.READ)
    @Schedule(minute="*", hour="*", second="0,20,40", persistent=false)
    public void scheduleWork() {
        Log.LOG.debugf("Pinger awake to ping", new Object[0]);
        this.urlChangesCollector.apply(this.destinations);
        if (this.destinations.size() == 0) {
            Log.LOG.debugf("Nothing to ping", new Object[0]);
            return;
        }
        this.doThePing(this.destinations);
    }

    private void doThePing(Set<PingDestination> destinations) {
        Log.LOG.debugf("About to ping %d URLs", destinations.size());
        ArrayList<Object> results = new ArrayList<Object>(destinations.size());
        HashMap<Future, PingDestination> futures = new HashMap<Future, PingDestination>(destinations.size());
        for (PingDestination destination : destinations) {
            Future result = this.pinger.ping(destination);
            futures.put(result, destination);
        }
        for (int round = 1; !futures.isEmpty() && round < 15; ++round) {
            Iterator iterator = futures.keySet().iterator();
            while (iterator.hasNext()) {
                Future f = (Future)iterator.next();
                if (!f.isDone()) continue;
                try {
                    results.add(f.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                iterator.remove();
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException f) {
                // empty catch block
            }
        }
        for (Map.Entry entry : futures.entrySet()) {
            ((Future)entry.getKey()).cancel(true);
            PingDestination destination = (PingDestination)entry.getValue();
            long now = System.currentTimeMillis();
            PingStatus ps = PingStatus.timeout((PingDestination)destination, (long)now, (int)7500);
            results.add(ps);
            Log.LOG.debugf("Timed out: %s", (Object)destination.getUrl());
        }
        this.reportResults(results);
    }

    private void reportResults(List<PingStatus> results) {
        if (results.size() == 0) {
            return;
        }
        for (PingStatus status : results) {
            this.metricPublisher.sendToMetricsViaRest(status);
            this.metricPublisher.publishToTopic(status);
            this.traitsPublisher.publish(status);
        }
    }
}

