/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.net.InetAddress;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.PingStatus;
import org.hawkular.component.pinger.Traits;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.Resource;

@Stateless
public class TraitsPublisher {
    private static final String TRAIT_PROPERTY_PREFIX = "trait-";
    @Resource(lookup="java:global/Hawkular/Inventory")
    private Inventory inventory;

    @Asynchronous
    public void publish(PingStatus status) {
        Traits traits = status.getTraits();
        PingDestination dest = status.getDestination();
        try {
            String poweredBy;
            Resources.ReadWrite resourceAccess = (Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)dest.getTenantId())).environments()).get((Object)dest.getEnvironmentId())).feedlessResources();
            org.hawkular.inventory.api.model.Resource resource = (org.hawkular.inventory.api.model.Resource)((Resources.Single)resourceAccess.get((Object)dest.getResourceId())).entity();
            Resource.Update.Builder updateBuilder = Resource.Update.builder();
            resource.getProperties().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(TRAIT_PROPERTY_PREFIX)).forEach(e -> {
                Resource.Update.Builder cfr_ignored_0 = (Resource.Update.Builder)updateBuilder.withProperty((String)e.getKey(), e.getValue());
            });
            updateBuilder.withProperty("trait-collected-on", (Object)traits.getTimestamp());
            InetAddress remoteAddress = traits.getRemoteAddress();
            if (remoteAddress != null) {
                updateBuilder.withProperty("trait-remote-address", (Object)remoteAddress.getHostAddress());
            }
            if ((poweredBy = traits.getPoweredBy()) != null) {
                updateBuilder.withProperty("trait-powered-by", (Object)poweredBy);
            }
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)dest.getTenantId())).environments()).get((Object)dest.getEnvironmentId())).feedlessResources()).update(dest.getResourceId(), (Object)updateBuilder.build());
        }
        catch (EntityNotFoundException e2) {
            Log.LOG.iResourceNotFound(dest.getResourceId(), dest.getTenantId());
        }
    }
}

